/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;

import java.util.Objects;

/**
 * Represents the implementation of subscriptionStatusType.
 */
public final class SubscriptionStatusType {

    private Class<? extends SubscriptionStatus> identityref;

    /**
     * Creates an instance of subscriptionStatusType.
     */
    private SubscriptionStatusType() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public SubscriptionStatusType(Class<? extends SubscriptionStatus> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of subscriptionStatusType for type identityref.
     *
     * @param value value of subscriptionStatusType for type identityref
     * @return subscriptionStatusType for type identityref
     */
    public static SubscriptionStatusType of(Class<? extends SubscriptionStatus> value) {
        return new SubscriptionStatusType(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends SubscriptionStatus> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends SubscriptionStatus> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubscriptionStatusType) {
            SubscriptionStatusType other = (SubscriptionStatusType) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(SubscriptionStatus.class)) {
            return SubscriptionStatus.subscriptionStatusToString();
        } else if (identityref.equals(Active.class)) {
            return Active.activeToString();
        } else if (identityref.equals(Inactive.class)) {
            return Inactive.inactiveToString();
        } else if (identityref.equals(Suspended.class)) {
            return Suspended.suspendedToString();
        } else if (identityref.equals(InError.class)) {
            return InError.inErrorToString();
        }
        return null;
    }
    /**
     * Returns the object of subscriptionStatusType fromString input String subscriptionStatusType.
     *
     * @param valInString value of input String
     * @return subscriptionStatusType
     */
    public static SubscriptionStatusType fromString(String valInString) {
        try {
            Class<? extends SubscriptionStatus> tmpVal = SubscriptionStatus.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
