/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.ContentTest;
import org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.CurrentValue;

/**
 * Abstraction of an entity which represents the functionality of ytbChoiceWithContainerAndLeafList.
 */
public interface YtbChoiceWithContainerAndLeafList {

    /**
     * Identify the leaf of YtbChoiceWithContainerAndLeafList.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents refer.
         */
        REFER(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute refer.
     *
     * @return refer value of refer
     */
    byte[] refer();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute contentTest.
     *
     * @return contentTest value of contentTest
     */
    ContentTest contentTest();

    /**
     * Returns the attribute currentValue.
     *
     * @return currentValue value of currentValue
     */
    CurrentValue currentValue();

    /**
     * Sets the attribute refer.
     *
     * @param refer value of refer
     */
    void refer(byte[] refer);

    /**
     * Sets the attribute contentTest.
     *
     * @param contentTest value of contentTest
     */
    void contentTest(ContentTest contentTest);

    /**
     * Sets the attribute currentValue.
     *
     * @param currentValue value of currentValue
     */
    void currentValue(CurrentValue currentValue);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}