/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826;

import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.ContentTest;
import org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.CurrentValue;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbChoiceWithContainerAndLeafList.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbChoiceWithContainerAndLeafListOpParam extends InnerModelObject implements YtbChoiceWithContainerAndLeafList {
    protected byte[] refer;
    protected BitSet valueLeafFlags = new BitSet();
    protected ContentTest contentTest;
    protected CurrentValue currentValue;

    @Override
    public byte[] refer() {
        return refer;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public ContentTest contentTest() {
        return contentTest;
    }

    @Override
    public CurrentValue currentValue() {
        return currentValue;
    }

    @Override
    public void refer(byte[] refer) {
        valueLeafFlags.set(LeafIdentifier.REFER.getLeafIndex());
        this.refer = refer;
    }

    @Override
    public void contentTest(ContentTest contentTest) {
        this.contentTest = contentTest;
    }

    @Override
    public void currentValue(CurrentValue currentValue) {
        this.currentValue = currentValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(refer, valueLeafFlags, contentTest, currentValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbChoiceWithContainerAndLeafListOpParam) {
            YtbChoiceWithContainerAndLeafListOpParam other = (YtbChoiceWithContainerAndLeafListOpParam) obj;
            return
                Objects.deepEquals(refer, other.refer) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(contentTest, other.contentTest) &&
                Objects.deepEquals(currentValue, other.currentValue);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("refer=" + refer)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("contentTest=" + contentTest)
            .add("currentValue=" + currentValue)
            .toString();
    }

    /**
     * Creates an instance of ytbChoiceWithContainerAndLeafListOpParam.
     */
    public YtbChoiceWithContainerAndLeafListOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}