/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.contenttest.choicecontainer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.contenttest.choicecontainer.choicecontainer.Predict;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of choiceContainer.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultChoiceContainer extends InnerModelObject implements ChoiceContainer {
    protected List<Predict> predict;

    @Override
    public List<Predict> predict() {
        return predict;
    }

    @Override
    public void predict(List<Predict> predict) {
        this.predict = predict;
    }

    @Override
    public void addToPredict(Predict addTo) {
        if (predict == null) {
            predict = new ArrayList<>();
        }
        predict.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(predict);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultChoiceContainer) {
            DefaultChoiceContainer other = (DefaultChoiceContainer) obj;
            return
                Objects.deepEquals(predict, other.predict);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("predict=" + predict)
            .toString();
    }


    /**
     * Creates an instance of defaultChoiceContainer.
     */
    public DefaultChoiceContainer() {
    }

}