/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatype.rev20160826;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype.EnumDer1;
import org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype.EnumLeafListUnion;
import org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype.UnionEnumUnion;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbDataType.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbDataTypeOpParam extends InnerModelObject implements YtbDataType {
    protected EnumDer1 yangAutoPrefixEnum;
    protected UnionEnumUnion unionEnum;
    protected List<EnumLeafListUnion> enumLeafList;
    protected List<EnumDer1> leafRefEnum;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public EnumDer1 yangAutoPrefixEnum() {
        return yangAutoPrefixEnum;
    }

    @Override
    public UnionEnumUnion unionEnum() {
        return unionEnum;
    }

    @Override
    public List<EnumLeafListUnion> enumLeafList() {
        return enumLeafList;
    }

    @Override
    public List<EnumDer1> leafRefEnum() {
        return leafRefEnum;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void yangAutoPrefixEnum(EnumDer1 yangAutoPrefixEnum) {
        valueLeafFlags.set(LeafIdentifier.YANGAUTOPREFIXENUM.getLeafIndex());
        this.yangAutoPrefixEnum = yangAutoPrefixEnum;
    }

    @Override
    public void unionEnum(UnionEnumUnion unionEnum) {
        valueLeafFlags.set(LeafIdentifier.UNIONENUM.getLeafIndex());
        this.unionEnum = unionEnum;
    }

    @Override
    public void enumLeafList(List<EnumLeafListUnion> enumLeafList) {
        valueLeafFlags.set(LeafIdentifier.ENUMLEAFLIST.getLeafIndex());
        this.enumLeafList = enumLeafList;
    }

    @Override
    public void leafRefEnum(List<EnumDer1> leafRefEnum) {
        valueLeafFlags.set(LeafIdentifier.LEAFREFENUM.getLeafIndex());
        this.leafRefEnum = leafRefEnum;
    }

    @Override
    public void addToEnumLeafList(EnumLeafListUnion addTo) {
        if (enumLeafList == null) {
            enumLeafList = new ArrayList<>();
        }
        enumLeafList.add(addTo);
    }


    @Override
    public void addToLeafRefEnum(EnumDer1 addTo) {
        if (leafRefEnum == null) {
            leafRefEnum = new ArrayList<>();
        }
        leafRefEnum.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixEnum, unionEnum, enumLeafList, leafRefEnum, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbDataTypeOpParam) {
            YtbDataTypeOpParam other = (YtbDataTypeOpParam) obj;
            return
                Objects.deepEquals(yangAutoPrefixEnum, other.yangAutoPrefixEnum) &&
                Objects.deepEquals(unionEnum, other.unionEnum) &&
                Objects.deepEquals(enumLeafList, other.enumLeafList) &&
                Objects.deepEquals(leafRefEnum, other.leafRefEnum) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("yangAutoPrefixEnum=" + yangAutoPrefixEnum)
            .add("unionEnum=" + unionEnum)
            .add("enumLeafList=" + enumLeafList)
            .add("leafRefEnum=" + leafRefEnum)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }

    /**
     * Creates an instance of ytbDataTypeOpParam.
     */
    public YtbDataTypeOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}