/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.def2.Bits;
import java.util.Objects;

/**
 * Represents the implementation of def2.
 */
public final class Def2 {

    private BitSet bits;

    /**
     * Creates an instance of def2.
     */
    private Def2() {
    }

    /**
     * Creates an instance of bits.
     *
     * @param bits value of bits
     */
    public Def2(BitSet bits) {
        this.bits = bits;
    }

    /**
     * Returns the object of def2 for type bits.
     *
     * @param value value of def2 for type bits
     * @return def2 for type bits
     */
    public static Def2 of(BitSet value) {
        return new Def2(value);
    }

    /**
     * Returns the attribute bits.
     *
     * @return bits value of bits
     */
    public BitSet bits() {
        return bits;
    }
    /**
     * Sets the attribute bits.
     *
     * @param bits value of bits
     */
    public void bits(BitSet bits) {
        this.bits = bits;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bits);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Def2) {
            Def2 other = (Def2) obj;
            return
                Objects.deepEquals(bits, other.bits);
        }
        return false;
    }

    @Override
    public String toString() {
        return Bits.toString(bits);
    }
    /**
     * Returns the object of def2 fromString input String def2.
     *
     * @param valInString value of input String
     * @return def2
     */
    public static Def2 fromString(String valInString) {
        try {
            BitSet tmpVal = Bits.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
