/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes;

import java.util.Objects;

/**
 * Represents the implementation of def6.
 */
public final class Def6 {

    private Class<? extends Type> identityref;

    /**
     * Creates an instance of def6.
     */
    private Def6() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public Def6(Class<? extends Type> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of def6 for type identityref.
     *
     * @param value value of def6 for type identityref
     * @return def6 for type identityref
     */
    public static Def6 of(Class<? extends Type> value) {
        return new Def6(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends Type> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends Type> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Def6) {
            Def6 other = (Def6) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(Type.class)) {
            return Type.typeToString();
        } else if (identityref.equals(Physical.class)) {
            return Physical.physicalToString();
        } else if (identityref.equals(Virtual.class)) {
            return Virtual.virtualToString();
        }
        return null;
    }
    /**
     * Returns the object of def6 fromString input String def6.
     *
     * @param valInString value of input String
     * @return def6
     */
    public static Def6 fromString(String valInString) {
        try {
            Class<? extends Type> tmpVal = Type.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
