/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.Sched;
import org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr1.Cont;
import org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr2.Listener;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbModuleWithContainer.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbModuleWithContainerOpParam extends InnerModelObject implements YtbModuleWithContainer {
    protected Sched sched;
    protected Cont cont;
    protected List<Listener> listener;

    @Override
    public Sched sched() {
        return sched;
    }

    @Override
    public Cont cont() {
        return cont;
    }

    @Override
    public List<Listener> listener() {
        return listener;
    }

    @Override
    public void sched(Sched sched) {
        this.sched = sched;
    }

    @Override
    public void cont(Cont cont) {
        this.cont = cont;
    }

    @Override
    public void listener(List<Listener> listener) {
        this.listener = listener;
    }

    @Override
    public void addToListener(Listener addTo) {
        if (listener == null) {
            listener = new ArrayList<>();
        }
        listener.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(sched, cont, listener);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbModuleWithContainerOpParam) {
            YtbModuleWithContainerOpParam other = (YtbModuleWithContainerOpParam) obj;
            return
                Objects.deepEquals(sched, other.sched) &&
                Objects.deepEquals(cont, other.cont) &&
                Objects.deepEquals(listener, other.listener);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("sched=" + sched)
            .add("cont=" + cont)
            .add("listener=" + listener)
            .toString();
    }

    /**
     * Creates an instance of ytbModuleWithContainerOpParam.
     */
    public YtbModuleWithContainerOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}