/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr1;

import java.util.List;
import org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr2.Listener;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of cont.
 */
public interface Cont extends Augmentable  {

    /**
     * Returns the attribute listener.
     *
     * @return listener list of listener
     */
    List<Listener> listener();

    /**
     * Sets the attribute listener.
     *
     * @param listener list of listener
     */
    void listener(List<Listener> listener);

    /**
     * Adds to the list of listener.
     *
     * @param addTo value of listener
     */
    void addToListener(Listener addTo);

}