/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr2;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of listener.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultListener extends InnerModelObject 
        implements Listener, MultiInstanceObject<ListenerKeys> {
    protected String yangAutoPrefixWait;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String yangAutoPrefixWait() {
        return yangAutoPrefixWait;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void yangAutoPrefixWait(String yangAutoPrefixWait) {
        valueLeafFlags.set(LeafIdentifier.YANGAUTOPREFIXWAIT.getLeafIndex());
        this.yangAutoPrefixWait = yangAutoPrefixWait;
    }

    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixWait, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultListener) {
            DefaultListener other = (DefaultListener) obj;
            return
                Objects.deepEquals(yangAutoPrefixWait, other.yangAutoPrefixWait) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("yangAutoPrefixWait=" + yangAutoPrefixWait)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultListener.
     */
    public DefaultListener() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}