/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmodulewithcontainer.rev20160826.ytbmodulewithcontainer.gr2;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of listener.
 */
public class ListenerKeys implements KeyInfo<DefaultListener> {
    protected String yangAutoPrefixWait;
    /**
     * Returns the attribute yangAutoPrefixWait.
     *
     * @return yangAutoPrefixWait value of yangAutoPrefixWait
     */
    public String yangAutoPrefixWait() {
        return yangAutoPrefixWait;
    }

    /**
     * Sets the value to attribute yangAutoPrefixWait.
     *
     * @param yangAutoPrefixWait value of yangAutoPrefixWait
     */
    public void yangAutoPrefixWait(String yangAutoPrefixWait) {
        this.yangAutoPrefixWait = yangAutoPrefixWait;
    }


    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixWait);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ListenerKeys) {
            ListenerKeys other = (ListenerKeys) obj;
            return
                Objects.deepEquals(yangAutoPrefixWait, other.yangAutoPrefixWait);
        }
        return false;
    }
}