/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmodulewithleaflist.rev20160826;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbModuleWithLeafList.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbModuleWithLeafListOpParam extends InnerModelObject implements YtbModuleWithLeafList {
    protected List<Long> time;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<Long> time() {
        return time;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void time(List<Long> time) {
        valueLeafFlags.set(LeafIdentifier.TIME.getLeafIndex());
        this.time = time;
    }

    @Override
    public void addToTime(Long addTo) {
        if (time == null) {
            time = new ArrayList<>();
        }
        time.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(time, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbModuleWithLeafListOpParam) {
            YtbModuleWithLeafListOpParam other = (YtbModuleWithLeafListOpParam) obj;
            return
                Objects.deepEquals(time, other.time) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("time=" + time)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }

    /**
     * Creates an instance of ytbModuleWithLeafListOpParam.
     */
    public YtbModuleWithLeafListOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}