/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbrpc.rev20160826;

import org.onosproject.yang.gen.v1.ytbrpc.rev20160826.ytbrpc.content.ContentInput;
import org.onosproject.yang.gen.v1.ytbrpc.rev20160826.ytbrpc.content.ContentOutput;
import org.onosproject.yang.model.RpcInput;
import org.onosproject.yang.model.RpcOutput;
import org.onosproject.yang.model.RpcService;

/**
 * Abstraction of an entity which represents the functionality of ytbRpc.
 */
public interface YtbRpcService extends RpcService {
    /**
     * Service interface of content.
     *
     * @param inputVar input of service interface content
     * @return rpcOutput output of service interface content
     */
    RpcOutput content(RpcInput inputVar);

}
