/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbrpc.rev20160826.ytbrpc.content;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbrpc.rev20160826.ytbrpc.content.contentoutput.OutCh;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of contentOutput.
 */
public class DefaultContentOutput extends InnerModelObject implements ContentOutput {
    protected OutCh outCh;

    @Override
    public OutCh outCh() {
        return outCh;
    }

    @Override
    public void outCh(OutCh outCh) {
        this.outCh = outCh;
    }

    @Override
    public int hashCode() {
        return Objects.hash(outCh);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultContentOutput) {
            DefaultContentOutput other = (DefaultContentOutput) obj;
            return
                Objects.deepEquals(outCh, other.outCh);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("outCh=" + outCh)
            .toString();
    }


    /**
     * Creates an instance of defaultContentOutput.
     */
    public DefaultContentOutput() {
    }

}