/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbsimplechoicecase.rev20160826.ytbsimplechoicecase.ytbfood.ytbsnack;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbsimplechoicecase.rev20160826.ytbsimplechoicecase.ytbfood.YtbSnack;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbSportsArena.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultYtbSportsArena extends InnerModelObject implements YtbSportsArena {
    protected String pretzel;
    protected String beer;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String pretzel() {
        return pretzel;
    }

    @Override
    public String beer() {
        return beer;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void pretzel(String pretzel) {
        valueLeafFlags.set(LeafIdentifier.PRETZEL.getLeafIndex());
        this.pretzel = pretzel;
    }

    @Override
    public void beer(String beer) {
        valueLeafFlags.set(LeafIdentifier.BEER.getLeafIndex());
        this.beer = beer;
    }

    @Override
    public int hashCode() {
        return Objects.hash(pretzel, beer, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultYtbSportsArena) {
            DefaultYtbSportsArena other = (DefaultYtbSportsArena) obj;
            return
                Objects.deepEquals(pretzel, other.pretzel) &&
                Objects.deepEquals(beer, other.beer) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("pretzel=" + pretzel)
            .add("beer=" + beer)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultYtbSportsArena.
     */
    public DefaultYtbSportsArena() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}