/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbtreebuilderforlisthavinglist.rev20160826.ytbtreebuilderforlisthavinglist.carrier;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbtreebuilderforlisthavinglist.rev20160826.ytbtreebuilderforlisthavinglist.carrier.multiplexes.ApplicationAreas;
import org.onosproject.yang.gen.v1.ytbtreebuilderforlisthavinglist.rev20160826.ytbtreebuilderforlisthavinglist.carrier.multiplexes.TypesEnum;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of multiplexes.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultMultiplexes extends InnerModelObject 
        implements Multiplexes, MultiInstanceObject<MultiplexesKeys> {
    protected TypesEnum types;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<ApplicationAreas> applicationAreas;

    @Override
    public TypesEnum types() {
        return types;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<ApplicationAreas> applicationAreas() {
        return applicationAreas;
    }

    @Override
    public void types(TypesEnum types) {
        valueLeafFlags.set(LeafIdentifier.TYPES.getLeafIndex());
        this.types = types;
    }

    @Override
    public void applicationAreas(List<ApplicationAreas> applicationAreas) {
        this.applicationAreas = applicationAreas;
    }

    @Override
    public void addToApplicationAreas(ApplicationAreas addTo) {
        if (applicationAreas == null) {
            applicationAreas = new ArrayList<>();
        }
        applicationAreas.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(types, valueLeafFlags, applicationAreas);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMultiplexes) {
            DefaultMultiplexes other = (DefaultMultiplexes) obj;
            return
                Objects.deepEquals(types, other.types) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(applicationAreas, other.applicationAreas);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("types=" + types)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("applicationAreas=" + applicationAreas)
            .toString();
    }


    /**
     * Creates an instance of defaultMultiplexes.
     */
    public DefaultMultiplexes() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}