/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ListIterator;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public final class ObjectProvider {
    private static final String E_DATATYPE = "Data type not supported.";
    private static final String T = "true";
    private static final String F = "false";
    private static final String E_NONEMPTY = "Value is of non Empty type";

    private ObjectProvider() {
    }

    public static Object getObject(YangType typeInfo, String v, YangDataTypes dataType) throws IllegalArgumentException {
        YangDataTypes type = dataType != null ? dataType : typeInfo.getDataType();
        switch (type) {
            case INT8: {
                return Byte.parseByte(v);
            }
            case UINT8: 
            case INT16: {
                return Short.parseShort(v);
            }
            case UINT16: 
            case INT32: {
                return Integer.parseInt(v);
            }
            case UINT32: 
            case INT64: {
                return Long.parseLong(v);
            }
            case UINT64: {
                return new BigInteger(v);
            }
            case EMPTY: {
                if (v == null || v.equals("")) {
                    return null;
                }
                if (v.equals(T) || v.equals(F)) {
                    return Boolean.parseBoolean(v);
                }
            }
            case BOOLEAN: {
                if (v.equals(T) || v.equals(F)) {
                    return Boolean.parseBoolean(v);
                }
                throw new IllegalArgumentException(E_DATATYPE);
            }
            case BINARY: 
            case BITS: 
            case IDENTITYREF: 
            case ENUMERATION: 
            case STRING: 
            case INSTANCE_IDENTIFIER: {
                return v;
            }
            case DECIMAL64: {
                return new BigDecimal(v);
            }
            case LEAFREF: {
                YangType refType = ((YangLeafRef)typeInfo.getDataTypeExtendedInfo()).getEffectiveDataType();
                return ObjectProvider.getObject(refType, v, refType.getDataType());
            }
            case DERIVED: {
                YangType<?> rt = ((YangDerivedInfo)typeInfo.getDataTypeExtendedInfo()).getReferredTypeDef().getTypeList().get(0);
                return ObjectProvider.getObject(rt, v, rt.getDataType());
            }
            case UNION: {
                return ObjectProvider.parseUnionTypeInfo(typeInfo, v);
            }
        }
        throw new IllegalArgumentException(E_DATATYPE);
    }

    private static Object parseUnionTypeInfo(YangType type, String leafValue) {
        ListIterator<YangType<?>> it = ((YangUnion)type.getDataTypeExtendedInfo()).getTypeList().listIterator();
        while (it.hasNext()) {
            YangType t = (YangType)it.next();
            try {
                return ObjectProvider.getObject(t, leafValue, t.getDataType());
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw new IllegalArgumentException("Invalid value of data");
    }
}

