/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.linker.impl;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.onosproject.yang.compiler.datamodel.CollisionDetector;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.Resolvable;
import org.onosproject.yang.compiler.datamodel.ResolvableType;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.TraversalType;
import org.onosproject.yang.compiler.datamodel.YangAtomicPath;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangBase;
import org.onosproject.yang.compiler.datamodel.YangCompilerAnnotation;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangDeviateAdd;
import org.onosproject.yang.compiler.datamodel.YangDeviateDelete;
import org.onosproject.yang.compiler.datamodel.YangDeviateReplace;
import org.onosproject.yang.compiler.datamodel.YangDeviation;
import org.onosproject.yang.compiler.datamodel.YangDeviationHolder;
import org.onosproject.yang.compiler.datamodel.YangEntityToResolveInfoImpl;
import org.onosproject.yang.compiler.datamodel.YangFeature;
import org.onosproject.yang.compiler.datamodel.YangFeatureHolder;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangIfFeature;
import org.onosproject.yang.compiler.datamodel.YangImport;
import org.onosproject.yang.compiler.datamodel.YangInclude;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangPathArgType;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.YangRelativePath;
import org.onosproject.yang.compiler.datamodel.YangResolutionInfo;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.YangUses;
import org.onosproject.yang.compiler.datamodel.YangXPathResolver;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.exceptions.ErrorMessages;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.ResolvableStatus;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.linker.exceptions.LinkerException;
import org.onosproject.yang.compiler.linker.impl.XpathLinkingTypes;
import org.onosproject.yang.compiler.linker.impl.YangLinkerUtils;
import org.onosproject.yang.compiler.linker.impl.YangXpathLinker;

public class YangResolutionInfoImpl<T>
extends DefaultLocationInfo
implements YangResolutionInfo<T>,
Serializable {
    private static final long serialVersionUID = 806201658L;
    private YangEntityToResolveInfoImpl<T> entityToResolveInfo;
    private YangReferenceResolver curRefResolver;
    private Stack<YangEntityToResolveInfoImpl<T>> partialResolvedStack;

    private YangResolutionInfoImpl() {
    }

    public YangResolutionInfoImpl(T dataNode, YangNode holderNode, int lineNumber, int charPositionInLine) {
        this.entityToResolveInfo = new YangEntityToResolveInfoImpl();
        this.entityToResolveInfo.setEntityToResolve(dataNode);
        this.entityToResolveInfo.setHolderOfEntityToResolve(holderNode);
        this.setLineNumber(lineNumber);
        this.setCharPosition(charPositionInLine);
        this.partialResolvedStack = new Stack();
    }

    @Override
    public void resolveLinkingForResolutionInfo(YangReferenceResolver dataModelRootNode) throws DataModelException {
        this.curRefResolver = dataModelRootNode;
        T entityToResolve = this.entityToResolveInfo.getEntityToResolve();
        if (entityToResolve instanceof Resolvable) {
            Resolvable resolvable = (Resolvable)entityToResolve;
            if (resolvable.getResolvableStatus() == ResolvableStatus.RESOLVED) {
                return;
            }
        } else {
            throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref");
        }
        this.addInPartialResolvedStack(this.entityToResolveInfo);
        this.linkAndResolvePartialResolvedStack();
        this.addDerivedRefTypeToRefTypeResolutionList();
    }

    private void linkAndResolvePartialResolvedStack() throws DataModelException {
        block6: while (!this.partialResolvedStack.isEmpty()) {
            T entityToResolve = this.getCurEntityToResolveFromStack();
            if (!(entityToResolve instanceof Resolvable)) {
                throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref");
            }
            Resolvable resolvable = (Resolvable)entityToResolve;
            switch (resolvable.getResolvableStatus()) {
                case RESOLVED: {
                    this.partialResolvedStack.pop();
                    continue block6;
                }
                case LINKED: {
                    this.resolveTopOfStack();
                    this.partialResolvedStack.pop();
                    continue block6;
                }
                case INTRA_FILE_RESOLVED: {
                    this.partialResolvedStack.pop();
                    continue block6;
                }
                case UNRESOLVED: {
                    this.linkTopOfStackReferenceUpdateStack();
                    if (resolvable.getResolvableStatus() != ResolvableStatus.UNRESOLVED) continue block6;
                    DataModelException ex = new DataModelException(YangLinkerUtils.getErrorInfoForLinker(resolvable));
                    ex.setLine(this.getLineNumber());
                    ex.setCharPosition(this.getCharPosition());
                    throw ex;
                }
            }
            throw new DataModelException("Data Model Exception: Unsupported, linker state");
        }
    }

    private void addDerivedRefTypeToRefTypeResolutionList() throws DataModelException {
        YangNode refNode = this.entityToResolveInfo.getHolderOfEntityToResolve();
        YangDerivedInfo info = this.getValidResolvableType();
        if (info == null) {
            return;
        }
        YangType type = (YangType)this.entityToResolveInfo.getEntityToResolve();
        Object extType = info.getReferredTypeDef().getTypeDefBaseType().getDataTypeExtendedInfo();
        while (extType instanceof YangDerivedInfo) {
            info = (YangDerivedInfo)extType;
            extType = info.getReferredTypeDef().getTypeDefBaseType().getDataTypeExtendedInfo();
        }
        this.addRefTypeInfo(extType, type, refNode);
    }

    private YangDerivedInfo<?> getValidResolvableType() {
        YangNode refNode = this.entityToResolveInfo.getHolderOfEntityToResolve();
        T entity = this.entityToResolveInfo.getEntityToResolve();
        if (!(refNode instanceof YangTypeDef) && entity instanceof YangType) {
            YangType type = (YangType)entity;
            YangDerivedInfo info = (YangDerivedInfo)type.getDataTypeExtendedInfo();
            YangDataTypes dataType = info.getEffectiveBuiltInType();
            if (type.getResolvableStatus() == ResolvableStatus.RESOLVED && dataType == YangDataTypes.LEAFREF) {
                return info;
            }
        }
        return null;
    }

    private void addRefTypeInfo(T extType, YangType<T> type, YangNode holder) throws DataModelException {
        type.resetYangType();
        type.setResolvableStatus(ResolvableStatus.RESOLVED);
        type.setDataType(YangDataTypes.LEAFREF);
        type.setDataTypeName("leafref");
        type.setDataTypeExtendedInfo(extType);
        YangLeafRef leafRef = (YangLeafRef)extType;
        leafRef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
        leafRef.setParentNode(holder);
        YangResolutionInfoImpl<YangLeafRef> info = new YangResolutionInfoImpl<YangLeafRef>(leafRef, holder, this.getLineNumber(), this.getCharPosition());
        this.curRefResolver.addToResolutionList(info, ResolvableType.YANG_LEAFREF);
        this.curRefResolver.resolveSelfFileLinking(ResolvableType.YANG_LEAFREF);
    }

    private void resolveTopOfStack() throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        List entityToResolve = (List)((Resolvable)entity).resolve();
        if (entityToResolve != null && !entityToResolve.isEmpty()) {
            for (Object anEntityToResolve : entityToResolve) {
                this.addUnresolvedEntitiesToResolutionList(anEntityToResolve);
            }
        }
        if (((Resolvable)entity).getResolvableStatus() != ResolvableStatus.INTRA_FILE_RESOLVED && ((Resolvable)entity).getResolvableStatus() != ResolvableStatus.UNDEFINED) {
            ((Resolvable)entity).setResolvableStatus(ResolvableStatus.RESOLVED);
        }
    }

    private void addUnresolvedEntitiesToResolutionList(T entityToResolve) throws DataModelException {
        if (entityToResolve instanceof YangEntityToResolveInfoImpl) {
            YangEntityToResolveInfoImpl entityToResolveInfo = (YangEntityToResolveInfoImpl)entityToResolve;
            if (entityToResolveInfo.getEntityToResolve() instanceof YangLeafRef) {
                YangLeafRef leafref = (YangLeafRef)entityToResolveInfo.getEntityToResolve();
                YangNode parentNodeOfLeafref = entityToResolveInfo.getHolderOfEntityToResolve();
                leafref.setParentNode(parentNodeOfLeafref);
                if (leafref.getResolvableStatus() == ResolvableStatus.UNRESOLVED) {
                    leafref.setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
                }
            }
            YangResolutionInfoImpl resolutionInfoImpl = new YangResolutionInfoImpl(entityToResolveInfo.getEntityToResolve(), entityToResolveInfo.getHolderOfEntityToResolve(), entityToResolveInfo.getLineNumber(), entityToResolveInfo.getCharPosition());
            DataModelUtils.addResolutionInfo(resolutionInfoImpl);
        }
    }

    private void linkTopOfStackReferenceUpdateStack() throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangLeafRef) {
            ((Resolvable)entity).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
            return;
        }
        if (!this.isCandidateForSelfFileReference()) {
            ((Resolvable)entity).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
            return;
        }
        YangNode ancestorRefNode = this.partialResolvedStack.peek().getHolderOfEntityToResolve();
        if (entity instanceof YangIfFeature) {
            this.resolveSelfFileLinkingForIfFeature(ancestorRefNode);
            return;
        }
        if (entity instanceof YangIdentityRef || entity instanceof YangBase) {
            this.resolveSelfFileLinkingForBaseAndIdentityref();
            return;
        }
        YangType type = null;
        if (entity instanceof YangType) {
            type = (YangType)entity;
        }
        while (ancestorRefNode != null) {
            YangNode curRefNode = ancestorRefNode.getChild();
            if (this.isReferredNodeInSiblingListProcessed(curRefNode)) {
                return;
            }
            ancestorRefNode = ancestorRefNode.getParent();
            if (type == null || ancestorRefNode == null || ancestorRefNode.getParent() != null) continue;
            type.setTypeNotResolvedTillRootNode(true);
        }
        if (this.getRefPrefix() == null || this.getRefPrefix().contentEquals(this.curRefResolver.getPrefix())) {
            ((Resolvable)entity).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
        }
    }

    private void resolveSelfFileLinkingForBaseAndIdentityref() throws DataModelException {
        boolean refIdentity = false;
        String nodeName = null;
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangIdentityRef) {
            nodeName = ((YangIdentityRef)entity).getName();
        } else if (entity instanceof YangBase) {
            nodeName = ((YangBase)entity).getBaseIdentifier().getName();
        }
        if (this.curRefResolver instanceof RpcNotificationContainer) {
            refIdentity = this.isIdentityReferenceFound(nodeName, (YangNode)((Object)this.curRefResolver));
        }
        if (refIdentity) {
            return;
        }
        if (this.getRefPrefix() == null || this.getRefPrefix().contentEquals(this.curRefResolver.getPrefix())) {
            ((Resolvable)entity).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
        }
    }

    private void resolveSelfFileLinkingForIfFeature(YangNode ancestorRefNode) throws DataModelException {
        YangFeatureHolder featureHolder = this.getFeatureHolder(ancestorRefNode);
        YangNode curRefNode = (YangNode)((Object)featureHolder);
        if (this.isReferredNode(curRefNode)) {
            this.addReferredEntityLink(curRefNode, ResolvableStatus.LINKED);
            this.addUnresolvedRecursiveReferenceToStack(curRefNode);
            return;
        }
        if (this.getRefPrefix() == null || this.getRefPrefix().contentEquals(this.curRefResolver.getPrefix())) {
            ((Resolvable)this.getCurEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
        }
    }

    private boolean isIdentityReferenceFound(String nodeName, YangNode ancestorRefNode) throws DataModelException {
        if (ancestorRefNode.getChild() == null) {
            return false;
        }
        YangNode nodeFound = this.isReferredNodeInSiblingProcessedForIdentity(ancestorRefNode = ancestorRefNode.getChild(), nodeName);
        if (nodeFound != null) {
            this.addReferredEntityLink(nodeFound, ResolvableStatus.LINKED);
            this.addUnresolvedRecursiveReferenceToStack(nodeFound);
            return true;
        }
        return false;
    }

    private void addUnResolvedLeafRefTypeToStack(T leavesInfo, YangNode ancestorRefNode) {
        YangType<?> refType;
        if (leavesInfo instanceof YangLeaf) {
            YangLeaf leaf = (YangLeaf)leavesInfo;
            refType = leaf.getDataType();
        } else {
            YangLeafList leafList = (YangLeafList)leavesInfo;
            refType = leafList.getDataType();
        }
        Object extendedInfo = refType.getDataTypeExtendedInfo();
        this.addUnResolvedTypeDataToStack(refType, ancestorRefNode, extendedInfo);
    }

    private void addUnResolvedTypeDataToStack(YangType refType, YangNode ancestorRefNode, T extendedInfo) {
        YangEntityToResolveInfoImpl<YangLeafRef> unResolvedLeafRef = new YangEntityToResolveInfoImpl<YangLeafRef>();
        YangEntityToResolveInfoImpl<YangType> unResolvedTypeDef = new YangEntityToResolveInfoImpl<YangType>();
        if (refType.getDataType() == YangDataTypes.LEAFREF) {
            unResolvedLeafRef.setEntityToResolve((YangLeafRef)extendedInfo);
            unResolvedLeafRef.setHolderOfEntityToResolve(ancestorRefNode);
            this.addInPartialResolvedStack(unResolvedLeafRef);
        } else if (refType.getDataType() == YangDataTypes.DERIVED) {
            unResolvedTypeDef.setEntityToResolve(refType);
            unResolvedTypeDef.setHolderOfEntityToResolve(ancestorRefNode);
            this.addInPartialResolvedStack(unResolvedTypeDef);
        }
    }

    private YangFeatureHolder getFeatureHolder(YangNode ancestorRefNode) {
        while (ancestorRefNode != null) {
            if (ancestorRefNode instanceof YangFeatureHolder) {
                return (YangFeatureHolder)((Object)ancestorRefNode);
            }
            ancestorRefNode = ancestorRefNode.getParent();
        }
        return null;
    }

    private boolean isCandidateForSelfFileReference() throws DataModelException {
        String prefix = this.getRefPrefix();
        return prefix == null || prefix.contentEquals(this.curRefResolver.getPrefix());
    }

    private YangNode isReferredNodeInSiblingProcessedForIdentity(YangNode refNode, String refName) throws DataModelException {
        while (refNode != null) {
            if (refNode instanceof YangIdentity && this.isReferredNodeForIdentity(refNode, refName)) {
                return refNode;
            }
            refNode = refNode.getNextSibling();
        }
        return null;
    }

    private boolean isReferredNodeForIdentity(YangNode curRefNode, String name) throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangIdentityRef || entity instanceof YangBase) {
            return curRefNode.getName().contentEquals(name);
        }
        throw new DataModelException(ErrorMessages.getErrorMsg("Data Model Exception: Entity to resolved is other than identityref", curRefNode.getName(), curRefNode.getLineNumber(), curRefNode.getCharPosition(), curRefNode.getFileName()));
    }

    private boolean isReferredNodeInSiblingListProcessed(YangNode refNode) throws DataModelException {
        while (refNode != null) {
            if (this.isReferredNode(refNode)) {
                this.addReferredEntityLink(refNode, ResolvableStatus.LINKED);
                this.addUnresolvedRecursiveReferenceToStack(refNode);
                return true;
            }
            refNode = refNode.getNextSibling();
        }
        return false;
    }

    private boolean isReferredNode(YangNode refNode) throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangType) {
            if (refNode instanceof YangTypeDef) {
                return this.isNodeNameSameAsResolutionInfoName(refNode);
            }
        } else if (entity instanceof YangUses) {
            if (refNode instanceof YangGrouping) {
                return this.isNodeNameSameAsResolutionInfoName(refNode);
            }
        } else if (entity instanceof YangIfFeature) {
            if (refNode instanceof YangFeatureHolder) {
                return this.isNodeNameSameAsResolutionInfoName(refNode);
            }
        } else if (entity instanceof YangBase || entity instanceof YangIdentityRef) {
            if (refNode instanceof YangIdentity) {
                return this.isNodeNameSameAsResolutionInfoName(refNode);
            }
        } else {
            throw new DataModelException(ErrorMessages.getErrorMsg("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref", refNode.getName(), refNode.getLineNumber(), refNode.getCharPosition(), refNode.getFileName()));
        }
        return false;
    }

    private boolean isNodeNameSameAsResolutionInfoName(YangNode node) throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangType) {
            return node.getName().contentEquals(((YangType)entity).getDataTypeName());
        }
        if (entity instanceof YangUses) {
            return node.getName().contentEquals(((YangUses)entity).getName());
        }
        if (entity instanceof YangIfFeature) {
            return this.isFeatureDefinedInNode(node);
        }
        if (entity instanceof YangBase) {
            return node.getName().contentEquals(((YangBase)entity).getBaseIdentifier().getName());
        }
        if (entity instanceof YangIdentityRef) {
            return node.getName().contentEquals(((YangIdentityRef)entity).getName());
        }
        throw new DataModelException(ErrorMessages.getErrorMsg("Data Model Exception: Entity to resolved is other than type/uses", node.getName(), node.getLineNumber(), node.getCharPosition(), node.getFileName()));
    }

    private boolean isFeatureDefinedInNode(YangNode node) {
        T entity = this.getCurEntityToResolveFromStack();
        YangNodeIdentifier ifFeature = ((YangIfFeature)entity).getName();
        List<YangFeature> featureList = ((YangFeatureHolder)((Object)node)).getFeatureList();
        if (featureList != null && !featureList.isEmpty()) {
            for (YangFeature feature : featureList) {
                if (!ifFeature.getName().equals(feature.getName())) continue;
                ((YangIfFeature)entity).setReferredFeature(feature);
                ((YangIfFeature)entity).setReferredFeatureHolder(node);
                return true;
            }
        }
        return false;
    }

    private void addReferredEntityLink(YangNode refNode, ResolvableStatus linkedStatus) throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangType) {
            YangDerivedInfo derivedInfo = (YangDerivedInfo)((YangType)entity).getDataTypeExtendedInfo();
            derivedInfo.setReferredTypeDef((YangTypeDef)refNode);
        } else if (entity instanceof YangUses) {
            ((YangUses)entity).setRefGroup((YangGrouping)refNode);
        } else if (entity instanceof YangBase) {
            ((YangBase)entity).setReferredIdentity((YangIdentity)refNode);
            this.addToIdentityExtendList(((YangBase)entity).getParentIdentity(), (YangIdentity)refNode);
        } else if (entity instanceof YangIdentityRef) {
            ((YangIdentityRef)entity).setReferredIdentity((YangIdentity)refNode);
        } else if (!(entity instanceof YangIfFeature) && !(entity instanceof YangLeafRef)) {
            throw new DataModelException(ErrorMessages.getErrorMsg("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref", refNode.getName(), refNode.getLineNumber(), refNode.getCharPosition(), refNode.getFileName()));
        }
        ((Resolvable)entity).setResolvableStatus(linkedStatus);
    }

    private void addToIdentityExtendList(YangIdentity baseIdentity, YangIdentity referredIdentity) {
        YangIdentity referredId = referredIdentity;
        while (referredId != null) {
            referredId.addToExtendList(baseIdentity);
            YangBase base = referredId.getBaseNode();
            if (base == null) {
                return;
            }
            referredId = base.getReferredIdentity();
        }
    }

    private void addUnresolvedRecursiveReferenceToStack(YangNode refNode) throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangType) {
            if (((YangTypeDef)refNode).getTypeDefBaseType().getDataType() == YangDataTypes.DERIVED) {
                this.addEntityToStack(((YangTypeDef)refNode).getTypeDefBaseType(), refNode);
            }
        } else if (entity instanceof YangUses) {
            this.addUnResolvedUsesToStack(refNode);
        } else if (entity instanceof YangIfFeature) {
            this.addUnResolvedIfFeatureToStack(refNode);
        } else {
            if (entity instanceof YangLeafRef) {
                throw new DataModelException(ErrorMessages.getErrorMsg("Data Model Exception: Entity to resolved is other than type/uses", refNode.getName(), refNode.getLineNumber(), refNode.getCharPosition(), refNode.getFileName()));
            }
            if (entity instanceof YangBase || entity instanceof YangIdentityRef) {
                this.addUnResolvedBaseToStack(refNode);
            } else {
                throw new DataModelException(ErrorMessages.getErrorMsg("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref", refNode.getName(), refNode.getLineNumber(), refNode.getCharPosition(), refNode.getFileName()));
            }
        }
    }

    private void addUnResolvedUsesToStack(YangNode node) {
        TraversalType curTraversal = TraversalType.ROOT;
        YangNode curNode = node.getChild();
        while (curNode != null) {
            if (curNode.getName().equals(node.getName())) {
                return;
            }
            if (curNode instanceof YangUses) {
                this.addEntityToStack(curNode, node);
            }
            if (curTraversal != TraversalType.PARENT && curNode.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                curNode = curNode.getChild();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                curTraversal = TraversalType.SIBLING;
                curNode = curNode.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            curNode = curNode.getParent();
        }
    }

    private void addUnResolvedIfFeatureToStack(YangNode node) {
        YangFeature refFeature = ((YangIfFeature)this.getCurEntityToResolveFromStack()).getReferredFeature();
        List<YangIfFeature> ifFeatureList = refFeature.getIfFeatureList();
        if (ifFeatureList != null && !ifFeatureList.isEmpty()) {
            Iterator<YangIfFeature> ifFeatureIterator = ifFeatureList.iterator();
            while (ifFeatureIterator.hasNext()) {
                this.addEntityToStack(ifFeatureIterator.next(), node);
            }
        }
    }

    private void addUnResolvedBaseToStack(YangNode node) {
        YangIdentity curNode = (YangIdentity)node;
        if (curNode.getBaseNode() != null && curNode.getBaseNode().getResolvableStatus() != ResolvableStatus.RESOLVED) {
            this.addEntityToStack(curNode.getBaseNode(), node);
        }
    }

    private void addEntityToStack(T entity, YangNode holder) {
        YangEntityToResolveInfoImpl<T> unResolvedEntityInfo = new YangEntityToResolveInfoImpl<T>();
        unResolvedEntityInfo.setEntityToResolve(entity);
        unResolvedEntityInfo.setHolderOfEntityToResolve(holder);
        this.addInPartialResolvedStack(unResolvedEntityInfo);
    }

    private void addInPartialResolvedStack(YangEntityToResolveInfoImpl<T> partialResolvedInfo) {
        this.partialResolvedStack.push(partialResolvedInfo);
    }

    private T getCurEntityToResolveFromStack() {
        return this.partialResolvedStack.peek().getEntityToResolve();
    }

    @Override
    public YangEntityToResolveInfoImpl<T> getEntityToResolveInfo() {
        return this.entityToResolveInfo;
    }

    @Override
    public void linkInterFile(YangReferenceResolver dataModelRootNode) throws DataModelException {
        this.curRefResolver = dataModelRootNode;
        T entityToResolve = this.entityToResolveInfo.getEntityToResolve();
        if (entityToResolve instanceof Resolvable) {
            Resolvable resolvable = (Resolvable)entityToResolve;
            if (resolvable.getResolvableStatus() == ResolvableStatus.RESOLVED) {
                return;
            }
        } else {
            throw new DataModelException("Data Model Exception: Entity to resolved is not Resolvable");
        }
        if (entityToResolve instanceof YangXPathResolver && !(entityToResolve instanceof YangLeafRef)) {
            this.processXPathLinking(entityToResolve, dataModelRootNode);
        } else {
            this.addInPartialResolvedStack(this.entityToResolveInfo);
            this.linkInterFileAndResolve();
            this.addDerivedRefTypeToRefTypeResolutionList();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processXPathLinking(T entityToResolve, YangReferenceResolver root) throws DataModelException {
        YangXpathLinker xPathLinker = new YangXpathLinker();
        YangNode node = this.entityToResolveInfo.getHolderOfEntityToResolve();
        if (entityToResolve instanceof YangAugment && !(node instanceof YangUses)) {
            YangAugment augment = (YangAugment)entityToResolve;
            YangNode targetNode = xPathLinker.processXpathLinking(augment.getTargetNode(), (YangNode)((Object)root), XpathLinkingTypes.AUGMENT_LINKING);
            if (targetNode == null) throw new LinkerException(ErrorMessages.getErrorMsg("Failed to link ", augment.getName(), augment.getLineNumber(), augment.getCharPosition(), augment.getFileName()));
            if (!(targetNode instanceof YangAugmentableNode)) throw new LinkerException(ErrorMessages.getErrorMsg("Invalid target node type " + (Object)((Object)targetNode.getNodeType()), augment.getName(), augment.getLineNumber(), augment.getCharPosition(), augment.getFileName()));
            YangLinkerUtils.detectCollisionForAugment(targetNode, augment, (YangNode)((Object)root));
            ((YangAugmentableNode)((Object)targetNode)).addAugmentation(augment);
            augment.setAugmentedNode(targetNode);
            this.setAugmentedFlagInAncestors(targetNode);
            Resolvable resolvable = (Resolvable)entityToResolve;
            resolvable.setResolvableStatus(ResolvableStatus.RESOLVED);
            if (!(targetNode instanceof YangInput)) return;
            xPathLinker.addInModuleIfInput(augment, (YangNode)((Object)root));
            return;
        }
        if (entityToResolve instanceof YangCompilerAnnotation) {
            YangCompilerAnnotation ca = (YangCompilerAnnotation)entityToResolve;
            YangNode targetNode = xPathLinker.processXpathLinking(ca.getAtomicPathList(), (YangNode)((Object)root), XpathLinkingTypes.AUGMENT_LINKING);
            if (targetNode == null) throw new LinkerException(ErrorMessages.getErrorMsg("Failed to link compiler annotation ", ca.getPath(), ca.getLineNumber(), ca.getCharPosition(), ca.getFileName()));
            if (!(targetNode instanceof YangList)) throw new LinkerException(ErrorMessages.getErrorMsg("Invalid target node type " + (Object)((Object)targetNode.getNodeType()), ca.getPath(), ca.getLineNumber(), ca.getCharPosition(), ca.getFileName()));
            ((YangList)targetNode).setCompilerAnnotation((YangCompilerAnnotation)entityToResolve);
            Resolvable resolvable = (Resolvable)entityToResolve;
            resolvable.setResolvableStatus(ResolvableStatus.RESOLVED);
            return;
        }
        if (entityToResolve instanceof YangLeafRef) {
            YangLeafRef leafRef = (YangLeafRef)entityToResolve;
            Object target = xPathLinker.processLeafRefXpathLinking(leafRef.getAtomicPath(), (YangNode)((Object)root), leafRef, XpathLinkingTypes.LEAF_REF_LINKING);
            if (target == null) {
                LinkerException ex = new LinkerException("YANG file error: Unable to find base leaf/leaf-list for given leafref path " + leafRef.getPath());
                ex.setCharPosition(leafRef.getCharPosition());
                ex.setLine(leafRef.getLineNumber());
                ex.setFileName(leafRef.getFileName());
                throw ex;
            }
            leafRef.setReferredLeafOrLeafList(target);
            if (target instanceof YangLeaf) {
                YangLeaf leaf = (YangLeaf)target;
                leafRef.setResolvableStatus(ResolvableStatus.INTER_FILE_LINKED);
                this.addUnResolvedLeafRefTypeToStack(leaf, this.entityToResolveInfo.getHolderOfEntityToResolve());
            } else {
                YangLeafList leafList = (YangLeafList)target;
                leafRef.setResolvableStatus(ResolvableStatus.INTER_FILE_LINKED);
                this.addUnResolvedLeafRefTypeToStack(leafList, this.entityToResolveInfo.getHolderOfEntityToResolve());
            }
            YangLinkerUtils.fillPathPredicates(leafRef);
            return;
        }
        if (!(entityToResolve instanceof YangDeviation)) {
            if (!(entityToResolve instanceof YangAugment)) return;
            this.resolveUsesAugment(entityToResolve, node);
            return;
        }
        YangDeviation deviation = (YangDeviation)entityToResolve;
        List<YangAtomicPath> path = deviation.getTargetNode();
        YangAtomicPath targetPath = path.get(path.size() - 1);
        YangSchemaNode target = this.findDeviationTarget(entityToResolve, root, xPathLinker);
        if (deviation.isDeviateNotSupported()) {
            this.resolveDeviationNotSupported(target, targetPath);
        } else {
            List<YangDeviateReplace> deviateReplaceList;
            List<YangDeviateDelete> deviateDeleteList;
            List<YangDeviateAdd> deviateAddList = deviation.getDeviateAdd();
            if (deviateAddList != null && !deviateAddList.isEmpty()) {
                this.resolveDeviateAdd(deviateAddList, target, targetPath);
            }
            if ((deviateDeleteList = deviation.getDeviateDelete()) != null && !deviateDeleteList.isEmpty()) {
                this.resolveDeviateDelete(deviateDeleteList, target, targetPath);
            }
            if ((deviateReplaceList = deviation.getDeviateReplace()) != null && !deviateReplaceList.isEmpty()) {
                this.resolveDeviateReplace(deviateReplaceList, target, targetPath);
            }
        }
        Resolvable resolvable = (Resolvable)entityToResolve;
        resolvable.setResolvableStatus(ResolvableStatus.RESOLVED);
    }

    private void resolveUsesAugment(T entity, YangNode node) {
        YangXpathLinker linker = new YangXpathLinker();
        YangAugment aug = (YangAugment)entity;
        YangNode tgt = linker.processUsesAugLinking(aug.getTargetNode(), (YangUses)node);
        if (tgt != null) {
            if (tgt instanceof YangAugmentableNode) {
                ((YangAugmentableNode)((Object)tgt)).addAugmentation(aug);
                aug.setAugmentedNode(tgt);
                this.setAugmentedFlagInAncestors(tgt);
                Resolvable resolvable = (Resolvable)entity;
                resolvable.setResolvableStatus(ResolvableStatus.RESOLVED);
                if (tgt instanceof YangInput) {
                    linker.addInModuleIfInput(aug, node);
                }
            } else {
                throw new LinkerException(ErrorMessages.getErrorMsg("Invalid target node type " + (Object)((Object)tgt.getNodeType()), aug.getName(), aug.getLineNumber(), aug.getCharPosition(), aug.getFileName()));
            }
        }
    }

    private void resolveDeviateAdd(List<YangDeviateAdd> deviateAddList, YangSchemaNode target, YangAtomicPath targetPath) throws DataModelException {
        for (YangDeviateAdd deviate : deviateAddList) {
            if (target.getName().equals(targetPath.getNodeIdentifier().getName())) {
                DataModelUtils.updateDeviateAddToTargetNode(target, deviate);
                continue;
            }
            YangSchemaNode leaf = DataModelUtils.findLeafNode((YangLeavesHolder)((Object)target), targetPath.getNodeIdentifier().getName());
            DataModelUtils.updateDeviateAddToTargetNode(leaf, deviate);
        }
    }

    private void resolveDeviateDelete(List<YangDeviateDelete> deviateDeleteList, YangSchemaNode target, YangAtomicPath targetPath) throws DataModelException {
        for (YangDeviateDelete deviate : deviateDeleteList) {
            if (target.getName().equals(targetPath.getNodeIdentifier().getName())) {
                DataModelUtils.updateDeviateDeleteToTargetNode(target, deviate);
                continue;
            }
            YangSchemaNode leaf = DataModelUtils.findLeafNode((YangLeavesHolder)((Object)target), targetPath.getNodeIdentifier().getName());
            DataModelUtils.updateDeviateDeleteToTargetNode(leaf, deviate);
        }
    }

    private void resolveDeviateReplace(List<YangDeviateReplace> deviateReplaceList, YangSchemaNode target, YangAtomicPath targetPath) throws DataModelException {
        for (YangDeviateReplace deviate : deviateReplaceList) {
            if (target.getName().equals(targetPath.getNodeIdentifier().getName())) {
                DataModelUtils.updateDeviateReplaceToTargetNode(target, deviate);
                continue;
            }
            YangSchemaNode leaf = DataModelUtils.findLeafNode((YangLeavesHolder)((Object)target), targetPath.getNodeIdentifier().getName());
            DataModelUtils.updateDeviateReplaceToTargetNode(leaf, deviate);
        }
    }

    private void resolveDeviationNotSupported(YangSchemaNode target, YangAtomicPath targetPath) {
        if (target.getName().equals(targetPath.getNodeIdentifier().getName())) {
            DataModelUtils.deleteUnsupportedNodeFromTree((YangNode)target);
        } else {
            DataModelUtils.deleteUnsupportedLeafOrLeafList((YangLeavesHolder)((Object)target), targetPath.getNodeIdentifier().getName());
        }
    }

    private YangSchemaNode findDeviationTarget(T entityToResolve, YangReferenceResolver root, YangXpathLinker<T> xPathLinker) throws DataModelException {
        YangDeviation deviation = (YangDeviation)entityToResolve;
        List<YangAtomicPath> path = deviation.getTargetNode();
        YangNode targetNode = xPathLinker.processXpathLinking(path, (YangNode)((Object)root), XpathLinkingTypes.DEVIATION_LINKING);
        if (targetNode != null) {
            YangNode clonedNode = this.cloneDeviatedModuleNode(targetNode, deviation);
            return xPathLinker.parsePath(clonedNode);
        }
        throw new LinkerException(ErrorMessages.getErrorMsg("Failed to link deviation ", deviation.getName(), deviation.getLineNumber(), deviation.getCharPosition(), deviation.getFileName()));
    }

    private YangNode cloneDeviatedModuleNode(YangNode targetNode, YangDeviation deviation) throws DataModelException {
        while (targetNode.getParent() != null) {
            targetNode = targetNode.getParent();
        }
        YangNode srcNode = targetNode;
        YangNode dstNode = deviation.getParent();
        if (((YangDeviationHolder)((Object)dstNode)).isDeviatedNodeCloned()) {
            return dstNode;
        }
        YangLeavesHolder destLeafHolder = (YangLeavesHolder)((Object)dstNode);
        YangLeavesHolder srcLeafHolder = (YangLeavesHolder)((Object)srcNode);
        if (srcLeafHolder.getListOfLeaf() != null) {
            for (YangLeaf leaf : srcLeafHolder.getListOfLeaf()) {
                YangLeaf clonedLeaf;
                try {
                    ((CollisionDetector)((Object)dstNode)).detectCollidingChild(leaf.getName(), YangConstructType.LEAF_DATA);
                    clonedLeaf = leaf.cloneForDeviation();
                    clonedLeaf.setReferredLeaf(leaf);
                }
                catch (CloneNotSupportedException | DataModelException e) {
                    throw new DataModelException(e.getMessage());
                }
                clonedLeaf.setContainedIn(destLeafHolder);
                destLeafHolder.addLeaf(clonedLeaf);
            }
        }
        if (srcLeafHolder.getListOfLeafList() != null) {
            for (YangLeafList leafList : srcLeafHolder.getListOfLeafList()) {
                YangLeafList clonedLeafList;
                try {
                    ((CollisionDetector)((Object)destLeafHolder)).detectCollidingChild(leafList.getName(), YangConstructType.LEAF_LIST_DATA);
                    clonedLeafList = leafList.cloneForDeviation();
                    clonedLeafList.setReferredSchemaLeafList(leafList);
                }
                catch (CloneNotSupportedException | DataModelException e) {
                    throw new DataModelException(e.getMessage());
                }
                clonedLeafList.setContainedIn(destLeafHolder);
                destLeafHolder.addLeafList(clonedLeafList);
            }
        }
        YangNode.cloneSubTree(srcNode, dstNode, null, true);
        ((YangDeviationHolder)((Object)dstNode)).setDeviatedNodeCloned(true);
        return dstNode;
    }

    private String getRefPrefix() throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangType) {
            return ((YangType)entity).getPrefix();
        }
        if (entity instanceof YangUses) {
            return ((YangUses)entity).getPrefix();
        }
        if (entity instanceof YangIfFeature) {
            return ((YangIfFeature)entity).getPrefix();
        }
        if (entity instanceof YangBase) {
            return ((YangBase)entity).getBaseIdentifier().getPrefix();
        }
        if (entity instanceof YangIdentityRef) {
            return ((YangIdentityRef)entity).getPrefix();
        }
        throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref");
    }

    private void linkInterFileAndResolve() throws DataModelException {
        while (!this.partialResolvedStack.isEmpty()) {
            T entityToResolve = this.getCurEntityToResolveFromStack();
            if (entityToResolve instanceof Resolvable) {
                Resolvable resolvable = (Resolvable)entityToResolve;
                switch (resolvable.getResolvableStatus()) {
                    case RESOLVED: {
                        this.partialResolvedStack.pop();
                        break;
                    }
                    case INTER_FILE_LINKED: {
                        this.resolveTopOfStack();
                        this.partialResolvedStack.pop();
                        break;
                    }
                    case INTRA_FILE_RESOLVED: {
                        this.linkInterFileTopOfStackRefUpdateStack();
                        break;
                    }
                    case UNDEFINED: {
                        this.partialResolvedStack.pop();
                        break;
                    }
                    default: {
                        throw new DataModelException("Data Model Exception: Unsupported, linker state");
                    }
                }
                continue;
            }
            throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses");
        }
    }

    private void linkInterFileTopOfStackRefUpdateStack() throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangLeafRef) {
            this.setAbsolutePathFromRelativePathInLeafref(entity);
            this.processXPathLinking(entity, this.curRefResolver);
            return;
        }
        T refNode = this.getRefNode();
        if (refNode == null) {
            if (this.getRefPrefix() != null && !this.getRefPrefix().contentEquals(this.curRefResolver.getPrefix()) ? this.resolveWithImport() : this.resolveWithInclude()) {
                return;
            }
            if (entity instanceof YangIfFeature) {
                ((YangIfFeature)entity).setResolvableStatus(ResolvableStatus.UNDEFINED);
                return;
            }
            DataModelException ex = new DataModelException(YangLinkerUtils.getErrorInfoForLinker(entity));
            ex.setLine(this.getLineNumber());
            ex.setCharPosition(this.getCharPosition());
            throw ex;
        }
        ((Resolvable)entity).setResolvableStatus(ResolvableStatus.INTER_FILE_LINKED);
        this.addUnresolvedRecursiveReferenceToStack((YangNode)refNode);
    }

    private void setAbsolutePathFromRelativePathInLeafref(T resolutionInfo) throws DataModelException {
        if (resolutionInfo instanceof YangLeafRef) {
            YangNode leafParent = ((YangLeafRef)resolutionInfo).getParentNode();
            YangLeafRef leafref = (YangLeafRef)resolutionInfo;
            if (leafref.getPathType() == YangPathArgType.RELATIVE_PATH) {
                YangRelativePath relativePath = leafref.getRelativePath();
                List<YangAtomicPath> absoluteInRelative = relativePath.getAtomicPathList();
                int ancestorCount = relativePath.getAncestorNodeCount();
                T nodeOrAugmentList = this.getRootNodeWithAncestorCountForLeafref(ancestorCount, leafParent, leafref);
                if (nodeOrAugmentList instanceof YangNode) {
                    StringBuilder name = new StringBuilder();
                    StringBuilder prefix = new StringBuilder();
                    YangNode rootNode = (YangNode)nodeOrAugmentList;
                    while (!(rootNode instanceof YangReferenceResolver)) {
                        name.append(rootNode.getName());
                        prefix.append("/").append((CharSequence)name.reverse());
                        name.delete(0, name.length());
                        if ((rootNode = rootNode.getParent()) != null) continue;
                        throw new DataModelException("Internal datamodel error: Datamodel tree is not correct");
                    }
                    prefix.reverse();
                    this.fillAbsolutePathValuesInLeafref(leafref, prefix.toString(), absoluteInRelative);
                } else {
                    List listOfAugment = (List)nodeOrAugmentList;
                    ListIterator listOfAugmentIterator = listOfAugment.listIterator();
                    StringBuilder augment = new StringBuilder("");
                    while (listOfAugmentIterator.hasNext()) {
                        augment.append("/").append((String)listOfAugmentIterator.next());
                    }
                    this.fillAbsolutePathValuesInLeafref(leafref, augment.toString(), absoluteInRelative);
                }
            }
        }
    }

    private void fillAbsolutePathValuesInLeafref(YangLeafRef leafref, String path, List<YangAtomicPath> relative) throws DataModelException {
        leafref.setPathType(YangPathArgType.ABSOLUTE_PATH);
        String[] pathName = new String[]{};
        if (path != null && !path.equals("")) {
            pathName = path.split("/");
        }
        LinkedList<YangAtomicPath> finalListForAbsolute = new LinkedList<YangAtomicPath>();
        for (String value : pathName) {
            if (value == null || value.isEmpty() || value.equals("")) continue;
            YangNodeIdentifier nodeId = YangLinkerUtils.getValidNodeIdentifier(value, YangConstructType.PATH_DATA);
            YangAtomicPath atomicPath = new YangAtomicPath();
            atomicPath.setNodeIdentifier(nodeId);
            finalListForAbsolute.add(atomicPath);
        }
        if (relative != null && !relative.isEmpty()) {
            ListIterator<YangAtomicPath> pathIt = relative.listIterator();
            while (pathIt.hasNext()) {
                YangAtomicPath yangAtomicPath = (YangAtomicPath)pathIt.next();
                finalListForAbsolute.add(yangAtomicPath);
            }
        } else {
            DataModelException ex = new DataModelException(YangLinkerUtils.getLeafRefErrorInfo(leafref));
            ex.setCharPosition(leafref.getCharPosition());
            ex.setLine(leafref.getLineNumber());
            ex.setFileName(leafref.getFileName());
            throw ex;
        }
        leafref.setAtomicPath(finalListForAbsolute);
    }

    private T getRootNodeWithAncestorCountForLeafref(int ancestorCount, YangNode curParent, YangLeafRef leafref) throws DataModelException {
        int curParentCount = 1;
        if ((curParent = YangLinkerUtils.skipInvalidDataNodes(curParent, leafref)) instanceof YangAugment) {
            YangAugment augment = (YangAugment)curParent;
            Object valueInAugment = YangLinkerUtils.getPathWithAugment(augment, ancestorCount - curParentCount);
            return (T)valueInAugment;
        }
        while (curParentCount < ancestorCount) {
            YangNode currentSkippedParent = YangLinkerUtils.skipInvalidDataNodes(curParent, leafref);
            if (currentSkippedParent == curParent) {
                if (curParent.getParent() == null) {
                    throw new DataModelException(YangLinkerUtils.getLeafRefErrorInfo(leafref));
                }
            } else {
                curParent = currentSkippedParent;
                continue;
            }
            curParent = curParent.getParent();
            ++curParentCount;
            if (!(curParent instanceof YangAugment)) continue;
            YangAugment augment = (YangAugment)curParent;
            Object valueInAugment = YangLinkerUtils.getPathWithAugment(augment, ancestorCount - curParentCount);
            return (T)valueInAugment;
        }
        return (T)curParent;
    }

    private boolean resolveWithInclude() throws DataModelException {
        for (YangInclude yangInclude : this.curRefResolver.getIncludeList()) {
            YangNode inc = yangInclude.getIncludedNode();
            YangNode linkedNode = this.getLinkedNode(inc);
            if (linkedNode == null) {
                linkedNode = this.getFromIncludeList(inc);
            }
            if (linkedNode == null) continue;
            return this.addUnResolvedRefToStack(linkedNode);
        }
        return false;
    }

    private boolean resolveWithImport() throws DataModelException {
        for (YangImport yangImport : this.curRefResolver.getImportList()) {
            if (!yangImport.getPrefixId().contentEquals(this.getRefPrefix())) continue;
            YangNode inc = yangImport.getImportedNode();
            YangNode linkedNode = this.getLinkedNode(inc);
            if (linkedNode == null) {
                linkedNode = this.getFromIncludeList(inc);
            }
            if (linkedNode == null) break;
            return this.addUnResolvedRefToStack(linkedNode);
        }
        return false;
    }

    private YangNode getFromIncludeList(YangNode node) {
        YangNode refNode;
        block1: {
            YangInclude inc;
            List<YangInclude> incList = ((YangReferenceResolver)((Object)node)).getIncludeList();
            refNode = null;
            if (incList == null || incList.isEmpty()) break block1;
            Iterator<YangInclude> iterator = incList.iterator();
            while (iterator.hasNext() && (refNode = this.getLinkedNode((inc = iterator.next()).getIncludedNode())) == null) {
            }
        }
        return refNode;
    }

    private boolean addUnResolvedRefToStack(YangNode linkedNode) throws DataModelException {
        this.addReferredEntityLink(linkedNode, ResolvableStatus.INTER_FILE_LINKED);
        this.addUnresolvedRecursiveReferenceToStack(linkedNode);
        return true;
    }

    private YangNode getLinkedNode(YangNode node) {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangType) {
            return this.findRefTypedef(node);
        }
        if (entity instanceof YangUses) {
            return this.findRefGrouping(node);
        }
        if (entity instanceof YangIfFeature) {
            return this.findRefFeature(node);
        }
        if (entity instanceof YangBase) {
            return this.findRefIdentity(node);
        }
        if (entity instanceof YangIdentityRef) {
            return this.findRefIdentityRef(node);
        }
        return null;
    }

    private T getRefNode() throws DataModelException {
        T entity = this.getCurEntityToResolveFromStack();
        if (entity instanceof YangType) {
            YangDerivedInfo derivedInfo = (YangDerivedInfo)((YangType)entity).getDataTypeExtendedInfo();
            return (T)derivedInfo.getReferredTypeDef();
        }
        if (entity instanceof YangUses) {
            return (T)((YangUses)entity).getRefGroup();
        }
        if (entity instanceof YangIfFeature) {
            return (T)((YangIfFeature)entity).getReferredFeatureHolder();
        }
        if (entity instanceof YangLeafRef) {
            return ((YangLeafRef)entity).getReferredLeafOrLeafList();
        }
        if (entity instanceof YangBase) {
            return (T)((YangBase)entity).getReferredIdentity();
        }
        if (entity instanceof YangIdentityRef) {
            return (T)((YangIdentityRef)entity).getReferredIdentity();
        }
        throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref");
    }

    private YangNode findRefGrouping(YangNode refNode) {
        for (YangNode tmpNode = refNode.getChild(); tmpNode != null; tmpNode = tmpNode.getNextSibling()) {
            if (!(tmpNode instanceof YangGrouping) || !tmpNode.getName().equals(((YangUses)this.getCurEntityToResolveFromStack()).getName())) continue;
            return tmpNode;
        }
        return null;
    }

    private YangNode findRefFeature(YangNode refNode) {
        T entity = this.getCurEntityToResolveFromStack();
        YangNodeIdentifier ifFeature = ((YangIfFeature)entity).getName();
        List<YangFeature> featureList = ((YangFeatureHolder)((Object)refNode)).getFeatureList();
        if (featureList != null && !featureList.isEmpty()) {
            for (YangFeature feature : featureList) {
                if (!ifFeature.getName().equals(feature.getName())) continue;
                ((YangIfFeature)entity).setReferredFeature(feature);
                return refNode;
            }
        }
        return null;
    }

    private YangNode findRefTypedef(YangNode refNode) {
        for (YangNode tmpNode = refNode.getChild(); tmpNode != null; tmpNode = tmpNode.getNextSibling()) {
            if (!(tmpNode instanceof YangTypeDef) || !tmpNode.getName().equals(((YangType)this.getCurEntityToResolveFromStack()).getDataTypeName())) continue;
            return tmpNode;
        }
        return null;
    }

    private YangNode findRefIdentity(YangNode refNode) {
        for (YangNode tmpNode = refNode.getChild(); tmpNode != null; tmpNode = tmpNode.getNextSibling()) {
            if (!(tmpNode instanceof YangIdentity) || !tmpNode.getName().equals(((YangBase)this.getCurEntityToResolveFromStack()).getBaseIdentifier().getName())) continue;
            return tmpNode;
        }
        return null;
    }

    private YangNode findRefIdentityRef(YangNode refNode) {
        for (YangNode tmpNode = refNode.getChild(); tmpNode != null; tmpNode = tmpNode.getNextSibling()) {
            if (!(tmpNode instanceof YangIdentity) || !tmpNode.getName().equals(((YangIdentityRef)this.getCurEntityToResolveFromStack()).getBaseIdentity().getName())) continue;
            return tmpNode;
        }
        return null;
    }

    private void setAugmentedFlagInAncestors(YangNode targetNode) {
        for (targetNode = targetNode.getParent(); targetNode != null; targetNode = targetNode.getParent()) {
            targetNode.setDescendantNodeAugmented(true);
        }
    }
}

