/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangAnydata;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangContainer;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.YangVersionHolder;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class AnydataListener {
    private AnydataListener() {
    }

    public static void processAnydataEntry(TreeWalkListener listener, GeneratedYangParser.AnydataStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ANYDATA_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.ANYDATA_DATA, ctx);
        AnydataListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.ANYDATA_DATA);
        YangAnydata anyData = YangDataModelFactory.getYangAnydataNode(GeneratedLanguage.JAVA_GENERATION);
        anyData.setName(identifier);
        anyData.setLineNumber(line);
        anyData.setCharPosition(charPositionInLine);
        anyData.setFileName(listener.getFileName());
        if (ctx.configStatement().isEmpty()) {
            boolean parentConfig = ListenerValidation.getParentNodeConfig(listener);
            anyData.setConfig(parentConfig);
        }
        Parsable curData = listener.getParsedDataStack().peek();
        if (!((YangVersionHolder)listener.getParsedDataStack().get(0)).getVersion().equals("1.1")) {
            throw new ParserException("YANG file error : anydata with name " + ctx.identifier().getText() + " at line number " + line + " in " + listener.getFileName() + " is feature of YANG version 1.1");
        }
        if (curData instanceof YangModule || curData instanceof YangSubModule || curData instanceof YangContainer || curData instanceof YangList || curData instanceof YangCase || curData instanceof YangNotification || curData instanceof YangInput || curData instanceof YangOutput || curData instanceof YangAugment || curData instanceof YangGrouping) {
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(anyData);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.ANYDATA_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ANYDATA_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(anyData);
    }

    public static void processAnydataExit(TreeWalkListener listener, GeneratedYangParser.AnydataStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ANYDATA_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangAnydata)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.ANYDATA_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.AnydataStatementContext ctx) {
        String text = ctx.identifier().getText();
        ListenerValidation.validateCardinalityMaxOne(ctx.whenStatement(), YangConstructType.WHEN_DATA, YangConstructType.ANYDATA_DATA, text);
        ListenerValidation.validateCardinalityMaxOne(ctx.configStatement(), YangConstructType.CONFIG_DATA, YangConstructType.ANYDATA_DATA, text);
        ListenerValidation.validateCardinalityMaxOne(ctx.mandatoryStatement(), YangConstructType.MANDATORY_DATA, YangConstructType.ANYDATA_DATA, text);
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.ANYDATA_DATA, text);
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.ANYDATA_DATA, text);
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.ANYDATA_DATA, text);
    }
}

