/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangDeviateAdd;
import org.onosproject.yang.compiler.datamodel.YangDeviateDelete;
import org.onosproject.yang.compiler.datamodel.YangDeviateReplace;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class UnitsListener {
    private UnitsListener() {
    }

    public static void processUnitsEntry(TreeWalkListener listener, GeneratedYangParser.UnitsStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.UNITS_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = listener.getParsedDataStack().peek();
        switch (tmpData.getYangConstructType()) {
            case LEAF_DATA: {
                YangLeaf leaf = (YangLeaf)tmpData;
                leaf.setUnits(ctx.string().getText());
                break;
            }
            case LEAF_LIST_DATA: {
                YangLeafList leafList = (YangLeafList)tmpData;
                leafList.setUnits(ctx.string().getText());
                break;
            }
            case TYPEDEF_DATA: {
                YangTypeDef typeDef = (YangTypeDef)tmpData;
                typeDef.setUnits(ctx.string().getText());
                break;
            }
            case DEVIATE_ADD: {
                YangDeviateAdd deviateAdd = (YangDeviateAdd)tmpData;
                deviateAdd.setUnits(ctx.string().getText());
                break;
            }
            case DEVIATE_DELETE: {
                YangDeviateDelete deviateDelete = (YangDeviateDelete)tmpData;
                deviateDelete.setUnits(ctx.string().getText());
                break;
            }
            case DEVIATE_REPLACE: {
                YangDeviateReplace replace = (YangDeviateReplace)tmpData;
                replace.setUnits(ctx.string().getText());
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.UNITS_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
            }
        }
    }
}

