/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModuleId;
import org.onosproject.yang.runtime.AppModuleInfo;
import org.onosproject.yang.runtime.ModelRegistrationParam;

public class DefaultModelRegistrationParam
implements ModelRegistrationParam {
    private final Map<YangModuleId, AppModuleInfo> appInfoMap;
    private YangModel model;

    protected DefaultModelRegistrationParam(Builder b) {
        this.appInfoMap = b.appInfoMap;
        this.model = b.model;
    }

    @Override
    public YangModel getYangModel() {
        return this.model;
    }

    @Override
    public AppModuleInfo getAppModuleInfo(YangModuleId id) {
        return this.appInfoMap.get(id);
    }

    @Override
    public boolean ifAppInfoPresent() {
        return !this.appInfoMap.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.appInfoMap, this.model);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DefaultModelRegistrationParam that = (DefaultModelRegistrationParam)obj;
        if (this.appInfoMap.size() == that.appInfoMap.size()) {
            for (Map.Entry<YangModuleId, AppModuleInfo> entry : this.appInfoMap.entrySet()) {
                if (that.appInfoMap.containsKey(entry.getKey()) && that.appInfoMap.containsValue(entry.getValue())) continue;
                return false;
            }
            return Objects.equals(this.model, that.model);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("model", (Object)this.model).add("appInfo", this.appInfoMap).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ModelRegistrationParam.Builder {
        private final Map<YangModuleId, AppModuleInfo> appInfoMap = new HashMap<YangModuleId, AppModuleInfo>();
        private YangModel model;

        @Override
        public Builder addAppModuleInfo(YangModuleId id, AppModuleInfo info) {
            this.appInfoMap.put(id, info);
            return this;
        }

        @Override
        public ModelRegistrationParam.Builder setYangModel(YangModel m) {
            this.model = m;
            return this;
        }

        @Override
        public DefaultModelRegistrationParam build() {
            return new DefaultModelRegistrationParam(this);
        }
    }
}

