/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.util.List;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultModelObjectData;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.ModelObject;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.DefaultDataNodeWalker;
import org.onosproject.yang.runtime.SerializerHelper;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.YobListener;
import org.onosproject.yang.runtime.impl.YobUtils;

public class DefaultYobBuilder {
    private final DefaultYangModelRegistry registry;
    private YangSchemaNode lastIndexNode;

    public DefaultYobBuilder(DefaultYangModelRegistry reg) {
        this.registry = reg;
    }

    public ModelObjectData getYangObject(ResourceData data) {
        List dataNodes;
        DefaultModelObjectData.Builder builder = DefaultModelObjectData.builder();
        ModelObjectId id = null;
        if (data.resourceId() != null) {
            id = this.convertRscIdToMoId(data.resourceId());
        }
        if (DataModelUtils.nonEmpty(dataNodes = data.dataNodes())) {
            for (DataNode dataNode : dataNodes) {
                YobListener listener = new YobListener(this.lastIndexNode, this.registry);
                DefaultDataNodeWalker.walk(listener, dataNode);
                List<ModelObject> objList = listener.modelObjectList();
                if (objList == null) continue;
                for (ModelObject obj : objList) {
                    builder.addModelObject(obj);
                }
            }
        }
        return builder.identifier(id).build();
    }

    private ModelObjectId convertRscIdToMoId(ResourceId id) {
        List nodeKeys;
        ModelObjectId.Builder midb = ModelObjectId.builder();
        if (id != null && DataModelUtils.nonEmpty(nodeKeys = id.nodeKeys())) {
            for (NodeKey key : nodeKeys) {
                SchemaId sId = key.schemaId();
                if (sId.name().equals("/")) continue;
                YangSchemaNode schemaNode = this.lastIndexNode == null ? (YangSchemaNode)this.registry.getChildContext(sId) : (YangSchemaNode)SerializerHelper.getChildSchemaContext(this.lastIndexNode, sId.name(), sId.namespace());
                if (schemaNode instanceof YangRpc) {
                    this.lastIndexNode = schemaNode;
                    return null;
                }
                if (key instanceof ListKey) {
                    midb = YobUtils.handleListKey(midb, this.registry, schemaNode, key);
                } else if (key instanceof LeafListKey) {
                    LeafListKey llKey = (LeafListKey)key;
                    midb = YobUtils.handleLeafListKey(midb, this.registry, schemaNode, llKey);
                } else {
                    midb = YobUtils.handleNodeKey(midb, this.registry, schemaNode, key);
                }
                if (schemaNode instanceof YangLeaf || schemaNode instanceof YangLeafList) continue;
                this.lastIndexNode = schemaNode;
            }
        }
        return midb.build();
    }
}

