/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of asNum.
 */
public abstract class AsNum extends AddressFamily {

    /**
     * Returns the attribute as-num.
     *
     * @return as-num value of as-num
     */
    public static String asNumToString() {
        return "as-num";
    }

    /**
     * Returns the object of asNum fromString input String asNum.
     *
     * @param valInString value of input String
     * @return asNum
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("as-num")) {
            return AsNum.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}