/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of ieee802.
 */
public abstract class Ieee802 extends AddressFamily {

    /**
     * Returns the attribute ieee802.
     *
     * @return ieee802 value of ieee802
     */
    public static String ieee802ToString() {
        return "ieee802";
    }

    /**
     * Returns the object of ieee802 fromString input String ieee802.
     *
     * @param valInString value of input String
     * @return ieee802
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("ieee802")) {
            return Ieee802.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}