/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.Ipv4Address;
import java.util.Objects;

/**
 * Represents the implementation of ipv4MulticastGroupAddress.
 */
public final class Ipv4MulticastGroupAddress {

    private Ipv4Address ipv4Address;

    /**
     * Creates an instance of ipv4MulticastGroupAddress.
     */
    private Ipv4MulticastGroupAddress() {
    }

    /**
     * Creates an instance of ipv4Address.
     *
     * @param ipv4Address value of ipv4Address
     */
    public Ipv4MulticastGroupAddress(Ipv4Address ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    /**
     * Returns the object of ipv4MulticastGroupAddress for type ipv4Address.
     *
     * @param value value of ipv4MulticastGroupAddress for type ipv4Address
     * @return ipv4MulticastGroupAddress for type ipv4Address
     */
    public static Ipv4MulticastGroupAddress of(Ipv4Address value) {
        return new Ipv4MulticastGroupAddress(value);
    }

    /**
     * Returns the attribute ipv4Address.
     *
     * @return ipv4Address value of ipv4Address
     */
    public Ipv4Address ipv4Address() {
        return ipv4Address;
    }
    /**
     * Sets the attribute ipv4Address.
     *
     * @param ipv4Address value of ipv4Address
     */
    public void ipv4Address(Ipv4Address ipv4Address) {
        this.ipv4Address = ipv4Address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(ipv4Address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ipv4MulticastGroupAddress) {
            Ipv4MulticastGroupAddress other = (Ipv4MulticastGroupAddress) obj;
            return
                Objects.deepEquals(ipv4Address, other.ipv4Address);
        }
        return false;
    }

    @Override
    public String toString() {
        return ipv4Address.toString();
    }
    /**
     * Returns the object of ipv4MulticastGroupAddress fromString input String ipv4MulticastGroupAddress.
     *
     * @param valInString value of input String
     * @return ipv4MulticastGroupAddress
     */
    public static Ipv4MulticastGroupAddress fromString(String valInString) {
        try {
            Ipv4Address tmpVal = Ipv4Address.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
