/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.ipv6multicastsourceaddress.Ipv6MulticastSourceAddressUnion;
import java.util.Objects;

/**
 * Represents the implementation of ipv6MulticastSourceAddress.
 */
public final class Ipv6MulticastSourceAddress {

    private Ipv6MulticastSourceAddressUnion union;

    /**
     * Creates an instance of ipv6MulticastSourceAddress.
     */
    private Ipv6MulticastSourceAddress() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public Ipv6MulticastSourceAddress(Ipv6MulticastSourceAddressUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of ipv6MulticastSourceAddress for type union.
     *
     * @param value value of ipv6MulticastSourceAddress for type union
     * @return ipv6MulticastSourceAddress for type union
     */
    public static Ipv6MulticastSourceAddress of(Ipv6MulticastSourceAddressUnion value) {
        return new Ipv6MulticastSourceAddress(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public Ipv6MulticastSourceAddressUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(Ipv6MulticastSourceAddressUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ipv6MulticastSourceAddress) {
            Ipv6MulticastSourceAddress other = (Ipv6MulticastSourceAddress) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of ipv6MulticastSourceAddress fromString input String ipv6MulticastSourceAddress.
     *
     * @param valInString value of input String
     * @return ipv6MulticastSourceAddress
     */
    public static Ipv6MulticastSourceAddress fromString(String valInString) {
        try {
            Ipv6MulticastSourceAddressUnion tmpVal = Ipv6MulticastSourceAddressUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
