/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.linkaccesstype.LinkAccessTypeEnum;
import java.util.Objects;

/**
 * Represents the implementation of linkAccessType.
 */
public final class LinkAccessType {

    private LinkAccessTypeEnum enumeration;

    /**
     * Creates an instance of linkAccessType.
     */
    private LinkAccessType() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public LinkAccessType(LinkAccessTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of linkAccessType for type enumeration.
     *
     * @param value value of linkAccessType for type enumeration
     * @return linkAccessType for type enumeration
     */
    public static LinkAccessType of(LinkAccessTypeEnum value) {
        return new LinkAccessType(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public LinkAccessTypeEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(LinkAccessTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinkAccessType) {
            LinkAccessType other = (LinkAccessType) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of linkAccessType fromString input String linkAccessType.
     *
     * @param valInString value of input String
     * @return linkAccessType
     */
    public static LinkAccessType fromString(String valInString) {
        try {
            LinkAccessTypeEnum tmpVal = LinkAccessTypeEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
