/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of mplsLabelSpecialPurposeValue.
 */
public abstract class MplsLabelSpecialPurposeValue {

    /**
     * Returns the attribute mpls-label-special-purpose-value.
     *
     * @return mpls-label-special-purpose-value value of mpls-label-special-purpose-value
     */
    public static String mplsLabelSpecialPurposeValueToString() {
        return "mpls-label-special-purpose-value";
    }

    /**
     * Returns the object of mplsLabelSpecialPurposeValue fromString input String mplsLabelSpecialPurposeValue.
     *
     * @param valInString value of input String
     * @return mplsLabelSpecialPurposeValue
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("mpls-label-special-purpose-value")) {
            return MplsLabelSpecialPurposeValue.class;
        } else if (valInString.equals("ipv4-explicit-null-label")) {
            return Ipv4ExplicitNullLabel.class;
        } else if (valInString.equals("router-alert-label")) {
            return RouterAlertLabel.class;
        } else if (valInString.equals("ipv6-explicit-null-label")) {
            return Ipv6ExplicitNullLabel.class;
        } else if (valInString.equals("implicit-null-label")) {
            return ImplicitNullLabel.class;
        } else if (valInString.equals("entropy-label-indicator")) {
            return EntropyLabelIndicator.class;
        } else if (valInString.equals("gal-label")) {
            return GalLabel.class;
        } else if (valInString.equals("oam-alert-label")) {
            return OamAlertLabel.class;
        } else if (valInString.equals("extension-label")) {
            return ExtensionLabel.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}