/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.mplslabelstack;

import java.util.List;
import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.mplslabelstack.mplslabelstack.Entry;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of mplsLabelStack.
 */
public interface MplsLabelStack extends Augmentable  {

    /**
     * Returns the attribute entry.
     *
     * @return entry list of entry
     */
    List<Entry> entry();

    /**
     * Sets the attribute entry.
     *
     * @param entry list of entry
     */
    void entry(List<Entry> entry);

    /**
     * Adds to the list of entry.
     *
     * @param addTo value of entry
     */
    void addToEntry(Entry addTo);

}