/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervalueseconds16;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervalueseconds16.timervalueseconds16union.TimerValueSeconds16UnionEnum1;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of timerValueSeconds16Union.
 */
public final class TimerValueSeconds16Union {
    private int uint16;
    private TimerValueSeconds16UnionEnum1 enumeration;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of timerValueSeconds16Union.
     */
    private TimerValueSeconds16Union() {
    }

    /**
     * Creates an instance of uint16.
     *
     * @param uint16 value of uint16
     */
    public TimerValueSeconds16Union(int uint16) {
        setValue.set(0);
        this.uint16 = uint16;
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TimerValueSeconds16Union(TimerValueSeconds16UnionEnum1 enumeration) {
        setValue.set(1);
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of timerValueSeconds16Union for type uint16.
     *
     * @param value value of timerValueSeconds16Union for type uint16
     * @return timerValueSeconds16Union for type uint16
     */
    public static TimerValueSeconds16Union of(int value) {
        return new TimerValueSeconds16Union(value);
    }

    /**
     * Returns the object of timerValueSeconds16Union for type enumeration.
     *
     * @param value value of timerValueSeconds16Union for type enumeration
     * @return timerValueSeconds16Union for type enumeration
     */
    public static TimerValueSeconds16Union of(TimerValueSeconds16UnionEnum1 value) {
        return new TimerValueSeconds16Union(value);
    }

    /**
     * Returns the attribute uint16.
     *
     * @return uint16 value of uint16
     */
    public int uint16() {
        return uint16;
    }
    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TimerValueSeconds16UnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute uint16.
     *
     * @param uint16 value of uint16
     */
    public void uint16(int uint16) {
        this.uint16 = uint16;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TimerValueSeconds16UnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint16, enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimerValueSeconds16Union) {
            TimerValueSeconds16Union other = (TimerValueSeconds16Union) obj;
            return
                Objects.deepEquals(uint16, other.uint16) &&
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint16);
        }
        if (setValue.get(1)) {
            return enumeration.toString();
        }
        return null;
    }
    /**
     * Returns the object of timerValueSeconds16Union fromString input String timerValueSeconds16Union.
     *
     * @param valInString value of input String
     * @return timerValueSeconds16Union
     */
    public static TimerValueSeconds16Union fromString(String valInString) {
        try {
            int tmpVal = Integer.parseInt(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            TimerValueSeconds16UnionEnum1 tmpVal = TimerValueSeconds16UnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
