/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of provStateActive.
 */
public abstract class ProvStateActive extends ProvStateType {

    /**
     * Returns the attribute prov-state-active.
     *
     * @return prov-state-active value of prov-state-active
     */
    public static String provStateActiveToString() {
        return "prov-state-active";
    }

    /**
     * Returns the object of provStateActive fromString input String provStateActive.
     *
     * @param valInString value of input String
     * @return provStateActive
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("prov-state-active")) {
            return ProvStateActive.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}