/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes;

/**
 * Represents the implementation of teOptimizationCriterion.
 */
public abstract class TeOptimizationCriterion {

    /**
     * Returns the attribute te-optimization-criterion.
     *
     * @return te-optimization-criterion value of te-optimization-criterion
     */
    public static String teOptimizationCriterionToString() {
        return "te-optimization-criterion";
    }

    /**
     * Returns the object of teOptimizationCriterion fromString input String teOptimizationCriterion.
     *
     * @param valInString value of input String
     * @return teOptimizationCriterion
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("te-optimization-criterion")) {
            return TeOptimizationCriterion.class;
        } else if (valInString.equals("not-optimized")) {
            return NotOptimized.class;
        } else if (valInString.equals("cost")) {
            return Cost.class;
        } else if (valInString.equals("delay")) {
            return Delay.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}