/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.recordroutesubobject.type;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.recordroutesubobject.Type;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of ipAddress.
 */
public interface IpAddress extends Type, Augmentable  {

    /**
     * Identify the leaf of IpAddress.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents ipAddress.
         */
        IPADDRESS(1),
        /**
         * Represents ipFlags.
         */
        IPFLAGS(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute ipAddress.
     *
     * @return ipAddress value of ipAddress
     */
    org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress ipAddress();

    /**
     * Returns the attribute ipFlags.
     *
     * @return ipFlags value of ipFlags
     */
    byte[] ipFlags();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute ipAddress.
     *
     * @param ipAddress value of ipAddress
     */
    void ipAddress(org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress ipAddress);

    /**
     * Sets the attribute ipFlags.
     *
     * @param ipFlags value of ipFlags
     */
    void ipFlags(byte[] ipFlags);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}