/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietftetypes.rev20170310.actnietftetypes.terecoverystatus;

/**
 * Represents ENUM data of teRecoveryStatusEnum.
 */
public enum TeRecoveryStatusEnum {

    /**
     * Represents normal.
     */
    NORMAL(0, "normal"),

    /**
     * Represents recovery-started.
     */
    RECOVERY_STARTED(1, "recovery-started"),

    /**
     * Represents recovery-succeeded.
     */
    RECOVERY_SUCCEEDED(2, "recovery-succeeded"),

    /**
     * Represents recovery-failed.
     */
    RECOVERY_FAILED(3, "recovery-failed"),

    /**
     * Represents reversion-started.
     */
    REVERSION_STARTED(4, "reversion-started"),

    /**
     * Represents reversion-failed.
     */
    REVERSION_FAILED(5, "reversion-failed"),

    /**
     * Represents recovery-unavailable.
     */
    RECOVERY_UNAVAILABLE(6, "recovery-unavailable"),

    /**
     * Represents recovery-admin.
     */
    RECOVERY_ADMIN(7, "recovery-admin"),

    /**
     * Represents wait-to-restore.
     */
    WAIT_TO_RESTORE(8, "wait-to-restore");

    private int teRecoveryStatusEnum;
    private String schemaName;

    /**
     * Creates an instance of teRecoveryStatusEnum.
     *
     * @param teRecoveryStatusEnum value of teRecoveryStatusEnum
     */
     TeRecoveryStatusEnum(int teRecoveryStatusEnum, String schemaName) {
        this.teRecoveryStatusEnum = teRecoveryStatusEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of teRecoveryStatusEnum for.
     *
     * @param value value of teRecoveryStatusEnum for
     * @return teRecoveryStatusEnum for
     */
    public static TeRecoveryStatusEnum of(int value) {
        switch (value) {
            case 0:
                return TeRecoveryStatusEnum.NORMAL;
            case 1:
                return TeRecoveryStatusEnum.RECOVERY_STARTED;
            case 2:
                return TeRecoveryStatusEnum.RECOVERY_SUCCEEDED;
            case 3:
                return TeRecoveryStatusEnum.RECOVERY_FAILED;
            case 4:
                return TeRecoveryStatusEnum.REVERSION_STARTED;
            case 5:
                return TeRecoveryStatusEnum.REVERSION_FAILED;
            case 6:
                return TeRecoveryStatusEnum.RECOVERY_UNAVAILABLE;
            case 7:
                return TeRecoveryStatusEnum.RECOVERY_ADMIN;
            case 8:
                return TeRecoveryStatusEnum.WAIT_TO_RESTORE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of teRecoveryStatusEnum for.
     *
     * @param value value of teRecoveryStatusEnum for
     * @return teRecoveryStatusEnum for
     */
    public static TeRecoveryStatusEnum of(String value) {
        switch (value) {
            case "normal":
                return TeRecoveryStatusEnum.NORMAL;
            case "recovery-started":
                return TeRecoveryStatusEnum.RECOVERY_STARTED;
            case "recovery-succeeded":
                return TeRecoveryStatusEnum.RECOVERY_SUCCEEDED;
            case "recovery-failed":
                return TeRecoveryStatusEnum.RECOVERY_FAILED;
            case "reversion-started":
                return TeRecoveryStatusEnum.REVERSION_STARTED;
            case "reversion-failed":
                return TeRecoveryStatusEnum.REVERSION_FAILED;
            case "recovery-unavailable":
                return TeRecoveryStatusEnum.RECOVERY_UNAVAILABLE;
            case "recovery-admin":
                return TeRecoveryStatusEnum.RECOVERY_ADMIN;
            case "wait-to-restore":
                return TeRecoveryStatusEnum.WAIT_TO_RESTORE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute teRecoveryStatusEnum.
     *
     * @return teRecoveryStatusEnum value of teRecoveryStatusEnum
     */
    public int teRecoveryStatusEnum() {
        return teRecoveryStatusEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
