/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid.augmentedschvalid;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of unlistedVal.
 */
public class UnlistedValKeys implements KeyInfo<DefaultUnlistedVal> {
    protected String presence;
    /**
     * Returns the attribute presence.
     *
     * @return presence value of presence
     */
    public String presence() {
        return presence;
    }

    /**
     * Sets the value to attribute presence.
     *
     * @param presence value of presence
     */
    public void presence(String presence) {
        this.presence = presence;
    }


    @Override
    public int hashCode() {
        return Objects.hash(presence);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnlistedValKeys) {
            UnlistedValKeys other = (UnlistedValKeys) obj;
            return
                Objects.deepEquals(presence, other.presence);
        }
        return false;
    }
}