/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest;

import org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes.Loopback;
import org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes.Physical;
import org.onosproject.yang.gen.v1.identitytypessecond.rev20130715.identitytypessecond.Ethernet;
import java.util.Objects;

/**
 * Represents the implementation of available.
 */
public final class Available {

    private Class<? extends Physical> identityref;

    /**
     * Creates an instance of available.
     */
    private Available() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public Available(Class<? extends Physical> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of available for type identityref.
     *
     * @param value value of available for type identityref
     * @return available for type identityref
     */
    public static Available of(Class<? extends Physical> value) {
        return new Available(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends Physical> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends Physical> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Available) {
            Available other = (Available) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(Physical.class)) {
            return Physical.physicalToString();
        } else if (identityref.equals(Loopback.class)) {
            return Loopback.loopbackToString();
        } else if (identityref.equals(Ethernet.class)) {
            return Ethernet.ethernetToString();
        } else if (identityref.equals(Giga.class)) {
            return Giga.gigaToString();
        }
        return null;
    }
    /**
     * Returns the object of available fromString input String available.
     *
     * @param valInString value of input String
     * @return available
     */
    public static Available fromString(String valInString) {
        try {
            Class<? extends Physical> tmpVal = Physical.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
