/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.typed;

import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.Giga;
import org.onosproject.yang.gen.v1.identitytest.rev20130715.identitytest.Optical;
import org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes.IntType;
import org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes.Loopback;
import org.onosproject.yang.gen.v1.identitytypes.rev20130715.identitytypes.Physical;
import org.onosproject.yang.gen.v1.identitytypessecond.rev20130715.identitytypessecond.Ethernet;
import org.onosproject.yang.gen.v1.identitytypessecond.rev20130715.identitytypessecond.Virtual;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of typedUnion.
 */
public final class TypedUnion {
    private int int32;
    private byte int8;
    private Class<? extends IntType> identityref;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of typedUnion.
     */
    private TypedUnion() {
    }

    /**
     * Creates an instance of int32.
     *
     * @param int32 value of int32
     */
    public TypedUnion(int int32) {
        setValue.set(0);
        this.int32 = int32;
    }

    /**
     * Creates an instance of int8.
     *
     * @param int8 value of int8
     */
    public TypedUnion(byte int8) {
        setValue.set(1);
        this.int8 = int8;
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public TypedUnion(Class<? extends IntType> identityref) {
        setValue.set(2);
        this.identityref = identityref;
    }

    /**
     * Returns the object of typedUnion for type int32.
     *
     * @param value value of typedUnion for type int32
     * @return typedUnion for type int32
     */
    public static TypedUnion of(int value) {
        return new TypedUnion(value);
    }

    /**
     * Returns the object of typedUnion for type int8.
     *
     * @param value value of typedUnion for type int8
     * @return typedUnion for type int8
     */
    public static TypedUnion of(byte value) {
        return new TypedUnion(value);
    }

    /**
     * Returns the object of typedUnion for type identityref.
     *
     * @param value value of typedUnion for type identityref
     * @return typedUnion for type identityref
     */
    public static TypedUnion of(Class<? extends IntType> value) {
        return new TypedUnion(value);
    }

    /**
     * Returns the attribute int32.
     *
     * @return int32 value of int32
     */
    public int int32() {
        return int32;
    }
    /**
     * Returns the attribute int8.
     *
     * @return int8 value of int8
     */
    public byte int8() {
        return int8;
    }
    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends IntType> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute int32.
     *
     * @param int32 value of int32
     */
    public void int32(int int32) {
        this.int32 = int32;
    }
    /**
     * Sets the attribute int8.
     *
     * @param int8 value of int8
     */
    public void int8(byte int8) {
        this.int8 = int8;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends IntType> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(int32, int8, identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TypedUnion) {
            TypedUnion other = (TypedUnion) obj;
            return
                Objects.deepEquals(int32, other.int32) &&
                Objects.deepEquals(int8, other.int8) &&
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(int32);
        }
        if (setValue.get(1)) {
            return String.valueOf(int8);
        }
        if (setValue.get(2)) {
            if (identityref.equals(IntType.class)) {
                return IntType.intTypeToString();
            } else if (identityref.equals(Physical.class)) {
                return Physical.physicalToString();
            } else if (identityref.equals(Virtual.class)) {
                return Virtual.virtualToString();
            } else if (identityref.equals(Optical.class)) {
                return Optical.opticalToString();
            } else if (identityref.equals(Giga.class)) {
                return Giga.gigaToString();
            } else if (identityref.equals(Ethernet.class)) {
                return Ethernet.ethernetToString();
            } else if (identityref.equals(Loopback.class)) {
                return Loopback.loopbackToString();
            }
        }
        return null;
    }
    /**
     * Returns the object of typedUnion fromString input String typedUnion.
     *
     * @param valInString value of input String
     * @return typedUnion
     */
    public static TypedUnion fromString(String valInString) {
        try {
            int tmpVal = Integer.parseInt(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            byte tmpVal = Byte.parseByte(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            Class<? extends IntType> tmpVal = IntType.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
