/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SiteVpnFlavor;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.SvcId;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.customerlocationinfo.Location;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.l3vpnsvc.sites.site.SiteNetworkAccesses;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitediversity.SiteDiversity;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitemanagement.Management;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitemaximumroutes.MaximumRoutes;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteprotection.TrafficProtection;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siterouting.RoutingProtocols;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitesecurity.Security;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteservice.Service;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.VpnPolicyList;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.DateAndTime;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of site.
 */
public interface Site extends Augmentable  {

    /**
     * Identify the leaf of Site.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents siteId.
         */
        SITEID(1),
        /**
         * Represents requestedSiteStart.
         */
        REQUESTEDSITESTART(2),
        /**
         * Represents requestedSiteStop.
         */
        REQUESTEDSITESTOP(3),
        /**
         * Represents siteVpnFlavor.
         */
        SITEVPNFLAVOR(4),
        /**
         * Represents actualSiteStart.
         */
        ACTUALSITESTART(5),
        /**
         * Represents actualSiteStop.
         */
        ACTUALSITESTOP(6);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute siteId.
     *
     * @return siteId value of siteId
     */
    SvcId siteId();

    /**
     * Returns the attribute requestedSiteStart.
     *
     * @return requestedSiteStart value of requestedSiteStart
     */
    DateAndTime requestedSiteStart();

    /**
     * Returns the attribute requestedSiteStop.
     *
     * @return requestedSiteStop value of requestedSiteStop
     */
    DateAndTime requestedSiteStop();

    /**
     * Returns the attribute siteVpnFlavor.
     *
     * @return siteVpnFlavor value of siteVpnFlavor
     */
    Class<? extends SiteVpnFlavor> siteVpnFlavor();

    /**
     * Returns the attribute actualSiteStart.
     *
     * @return actualSiteStart value of actualSiteStart
     */
    DateAndTime actualSiteStart();

    /**
     * Returns the attribute actualSiteStop.
     *
     * @return actualSiteStop value of actualSiteStop
     */
    DateAndTime actualSiteStop();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute siteNetworkAccesses.
     *
     * @return siteNetworkAccesses value of siteNetworkAccesses
     */
    SiteNetworkAccesses siteNetworkAccesses();

    /**
     * Returns the attribute location.
     *
     * @return location value of location
     */
    Location location();

    /**
     * Returns the attribute siteDiversity.
     *
     * @return siteDiversity value of siteDiversity
     */
    SiteDiversity siteDiversity();

    /**
     * Returns the attribute management.
     *
     * @return management value of management
     */
    Management management();

    /**
     * Returns the attribute vpnPolicyList.
     *
     * @return vpnPolicyList value of vpnPolicyList
     */
    VpnPolicyList vpnPolicyList();

    /**
     * Returns the attribute maximumRoutes.
     *
     * @return maximumRoutes value of maximumRoutes
     */
    MaximumRoutes maximumRoutes();

    /**
     * Returns the attribute security.
     *
     * @return security value of security
     */
    Security security();

    /**
     * Returns the attribute service.
     *
     * @return service value of service
     */
    Service service();

    /**
     * Returns the attribute trafficProtection.
     *
     * @return trafficProtection value of trafficProtection
     */
    TrafficProtection trafficProtection();

    /**
     * Returns the attribute routingProtocols.
     *
     * @return routingProtocols value of routingProtocols
     */
    RoutingProtocols routingProtocols();

    /**
     * Sets the attribute siteId.
     *
     * @param siteId value of siteId
     */
    void siteId(SvcId siteId);

    /**
     * Sets the attribute requestedSiteStart.
     *
     * @param requestedSiteStart value of requestedSiteStart
     */
    void requestedSiteStart(DateAndTime requestedSiteStart);

    /**
     * Sets the attribute requestedSiteStop.
     *
     * @param requestedSiteStop value of requestedSiteStop
     */
    void requestedSiteStop(DateAndTime requestedSiteStop);

    /**
     * Sets the attribute siteVpnFlavor.
     *
     * @param siteVpnFlavor value of siteVpnFlavor
     */
    void siteVpnFlavor(Class<? extends SiteVpnFlavor> siteVpnFlavor);

    /**
     * Sets the attribute actualSiteStart.
     *
     * @param actualSiteStart value of actualSiteStart
     */
    void actualSiteStart(DateAndTime actualSiteStart);

    /**
     * Sets the attribute actualSiteStop.
     *
     * @param actualSiteStop value of actualSiteStop
     */
    void actualSiteStop(DateAndTime actualSiteStop);

    /**
     * Sets the attribute siteNetworkAccesses.
     *
     * @param siteNetworkAccesses value of siteNetworkAccesses
     */
    void siteNetworkAccesses(SiteNetworkAccesses siteNetworkAccesses);

    /**
     * Sets the attribute location.
     *
     * @param location value of location
     */
    void location(Location location);

    /**
     * Sets the attribute siteDiversity.
     *
     * @param siteDiversity value of siteDiversity
     */
    void siteDiversity(SiteDiversity siteDiversity);

    /**
     * Sets the attribute management.
     *
     * @param management value of management
     */
    void management(Management management);

    /**
     * Sets the attribute vpnPolicyList.
     *
     * @param vpnPolicyList value of vpnPolicyList
     */
    void vpnPolicyList(VpnPolicyList vpnPolicyList);

    /**
     * Sets the attribute maximumRoutes.
     *
     * @param maximumRoutes value of maximumRoutes
     */
    void maximumRoutes(MaximumRoutes maximumRoutes);

    /**
     * Sets the attribute security.
     *
     * @param security value of security
     */
    void security(Security security);

    /**
     * Sets the attribute service.
     *
     * @param service value of service
     */
    void service(Service service);

    /**
     * Sets the attribute trafficProtection.
     *
     * @param trafficProtection value of trafficProtection
     */
    void trafficProtection(TrafficProtection trafficProtection);

    /**
     * Sets the attribute routingProtocols.
     *
     * @param routingProtocols value of routingProtocols
     */
    void routingProtocols(RoutingProtocols routingProtocols);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}