/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix;

import java.util.List;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix.lanprefixes.Ipv4LanPrefixes;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix.lanprefixes.Ipv6LanPrefixes;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of lanPrefixes.
 */
public interface LanPrefixes extends Augmentable  {

    /**
     * Returns the attribute ipv4LanPrefixes.
     *
     * @return ipv4LanPrefixes list of ipv4LanPrefixes
     */
    List<Ipv4LanPrefixes> ipv4LanPrefixes();

    /**
     * Returns the attribute ipv6LanPrefixes.
     *
     * @return ipv6LanPrefixes list of ipv6LanPrefixes
     */
    List<Ipv6LanPrefixes> ipv6LanPrefixes();

    /**
     * Sets the attribute ipv4LanPrefixes.
     *
     * @param ipv4LanPrefixes list of ipv4LanPrefixes
     */
    void ipv4LanPrefixes(List<Ipv4LanPrefixes> ipv4LanPrefixes);

    /**
     * Sets the attribute ipv6LanPrefixes.
     *
     * @param ipv6LanPrefixes list of ipv6LanPrefixes
     */
    void ipv6LanPrefixes(List<Ipv6LanPrefixes> ipv6LanPrefixes);

    /**
     * Adds to the list of ipv4LanPrefixes.
     *
     * @param addTo value of ipv4LanPrefixes
     */
    void addToIpv4LanPrefixes(Ipv4LanPrefixes addTo);

    /**
     * Adds to the list of ipv6LanPrefixes.
     *
     * @param addTo value of ipv6LanPrefixes
     */
    void addToIpv6LanPrefixes(Ipv6LanPrefixes addTo);

}