/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpgroupmappings;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpgroupmappings.rpgroupmapping.Groups;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.vpnservicemulticast.multicast.rp.rpgroupmappings.rpgroupmapping.ProviderManaged;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddress;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of rpGroupMapping.
 */
public interface RpGroupMapping extends Augmentable  {

    /**
     * Identify the leaf of RpGroupMapping.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents id.
         */
        ID(1),
        /**
         * Represents rpAddress.
         */
        RPADDRESS(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute id.
     *
     * @return id value of id
     */
    int id();

    /**
     * Returns the attribute rpAddress.
     *
     * @return rpAddress value of rpAddress
     */
    IpAddress rpAddress();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute providerManaged.
     *
     * @return providerManaged value of providerManaged
     */
    ProviderManaged providerManaged();

    /**
     * Returns the attribute groups.
     *
     * @return groups value of groups
     */
    Groups groups();

    /**
     * Sets the attribute id.
     *
     * @param id value of id
     */
    void id(int id);

    /**
     * Sets the attribute rpAddress.
     *
     * @param rpAddress value of rpAddress
     */
    void rpAddress(IpAddress rpAddress);

    /**
     * Sets the attribute providerManaged.
     *
     * @param providerManaged value of providerManaged
     */
    void providerManaged(ProviderManaged providerManaged);

    /**
     * Sets the attribute groups.
     *
     * @param groups value of groups
     */
    void groups(Groups groups);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}