/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.extendedcommunity;

import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.ExtendedCommunity;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.extendedcommunity.extendedcommunity.routetargetipv4case.RouteTargetIpv4;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of routeTargetIpv4Case.
 */
public interface RouteTargetIpv4Case extends ExtendedCommunity, Augmentable  {

    /**
     * Returns the attribute routeTargetIpv4.
     *
     * @return routeTargetIpv4 value of routeTargetIpv4
     */
    RouteTargetIpv4 routeTargetIpv4();

    /**
     * Sets the attribute routeTargetIpv4.
     *
     * @param routeTargetIpv4 value of routeTargetIpv4
     */
    void routeTargetIpv4(RouteTargetIpv4 routeTargetIpv4);

}