/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.rdrtprofile.siterole.customcase.custom;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of importRt.
 */
public class ImportRtKeys implements KeyInfo<DefaultImportRt> {
    protected String imrtId;
    /**
     * Returns the attribute imrtId.
     *
     * @return imrtId value of imrtId
     */
    public String imrtId() {
        return imrtId;
    }

    /**
     * Sets the value to attribute imrtId.
     *
     * @param imrtId value of imrtId
     */
    public void imrtId(String imrtId) {
        this.imrtId = imrtId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(imrtId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ImportRtKeys) {
            ImportRtKeys other = (ImportRtKeys) obj;
            return
                Objects.deepEquals(imrtId, other.imrtId);
        }
        return false;
    }
}