/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.group1.GroupContainer;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of containerGrouping.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultContainerGrouping extends InnerModelObject implements ContainerGrouping {
    protected GroupContainer groupContainer;

    @Override
    public GroupContainer groupContainer() {
        return groupContainer;
    }

    @Override
    public void groupContainer(GroupContainer groupContainer) {
        this.groupContainer = groupContainer;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupContainer);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultContainerGrouping) {
            DefaultContainerGrouping other = (DefaultContainerGrouping) obj;
            return
                Objects.deepEquals(groupContainer, other.groupContainer);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("groupContainer=" + groupContainer)
            .toString();
    }


    /**
     * Creates an instance of defaultContainerGrouping.
     */
    public DefaultContainerGrouping() {
    }

}