/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.containerleaflist.LeafList2Enum;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of containerLeafList.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultContainerLeafList extends InnerModelObject implements ContainerLeafList {
    protected List<LeafList2Enum> leafList2;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<LeafList2Enum> leafList2() {
        return leafList2;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leafList2(List<LeafList2Enum> leafList2) {
        valueLeafFlags.set(LeafIdentifier.LEAFLIST2.getLeafIndex());
        this.leafList2 = leafList2;
    }

    @Override
    public void addToLeafList2(LeafList2Enum addTo) {
        if (leafList2 == null) {
            leafList2 = new ArrayList<>();
        }
        leafList2.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leafList2, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultContainerLeafList) {
            DefaultContainerLeafList other = (DefaultContainerLeafList) obj;
            return
                Objects.deepEquals(leafList2, other.leafList2) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leafList2=" + leafList2)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultContainerLeafList.
     */
    public DefaultContainerLeafList() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}