/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Bitdef;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Id;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Ll1Union;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Ll6Enum;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.ModKey;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Tdef1;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Type;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.Val;
import org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey.YangAutoPrefixInt;

/**
 * Abstraction of an entity which represents the functionality of moduleListAndKey.
 */
public interface ModuleListAndKey {

    /**
     * Identify the leaf of ModuleListAndKey.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents tri.
         */
        TRI(1),
        /**
         * Represents ll1.
         */
        LL1(2),
        /**
         * Represents ll2.
         */
        LL2(3),
        /**
         * Represents ll3.
         */
        LL3(4),
        /**
         * Represents ll4.
         */
        LL4(5),
        /**
         * Represents ll5.
         */
        LL5(6),
        /**
         * Represents ll6.
         */
        LL6(7),
        /**
         * Represents ll7.
         */
        LL7(8),
        /**
         * Represents ll8.
         */
        LL8(9),
        /**
         * Represents ll9.
         */
        LL9(10);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute tri.
     *
     * @return tri list of tri
     */
    List<Class<? extends YangAutoPrefixInt>> tri();

    /**
     * Returns the attribute ll1.
     *
     * @return ll1 list of ll1
     */
    List<Ll1Union> ll1();

    /**
     * Returns the attribute ll2.
     *
     * @return ll2 list of ll2
     */
    List<Class<? extends YangAutoPrefixInt>> ll2();

    /**
     * Returns the attribute ll3.
     *
     * @return ll3 list of ll3
     */
    List<Tdef1> ll3();

    /**
     * Returns the attribute ll4.
     *
     * @return ll4 list of ll4
     */
    List<Class<? extends YangAutoPrefixInt>> ll4();

    /**
     * Returns the attribute ll5.
     *
     * @return ll5 list of ll5
     */
    List<String> ll5();

    /**
     * Returns the attribute ll6.
     *
     * @return ll6 list of ll6
     */
    List<Ll6Enum> ll6();

    /**
     * Returns the attribute ll7.
     *
     * @return ll7 list of ll7
     */
    List<Bitdef> ll7();

    /**
     * Returns the attribute ll8.
     *
     * @return ll8 list of ll8
     */
    List<byte[]> ll8();

    /**
     * Returns the attribute ll9.
     *
     * @return ll9 list of ll9
     */
    List<Id> ll9();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute modKey.
     *
     * @return modKey list of modKey
     */
    List<ModKey> modKey();

    /**
     * Returns the attribute type.
     *
     * @return type list of type
     */
    List<Type> type();

    /**
     * Returns the attribute val.
     *
     * @return val value of val
     */
    Val val();

    /**
     * Sets the attribute tri.
     *
     * @param tri list of tri
     */
    void tri(List<Class<? extends YangAutoPrefixInt>> tri);

    /**
     * Sets the attribute ll1.
     *
     * @param ll1 list of ll1
     */
    void ll1(List<Ll1Union> ll1);

    /**
     * Sets the attribute ll2.
     *
     * @param ll2 list of ll2
     */
    void ll2(List<Class<? extends YangAutoPrefixInt>> ll2);

    /**
     * Sets the attribute ll3.
     *
     * @param ll3 list of ll3
     */
    void ll3(List<Tdef1> ll3);

    /**
     * Sets the attribute ll4.
     *
     * @param ll4 list of ll4
     */
    void ll4(List<Class<? extends YangAutoPrefixInt>> ll4);

    /**
     * Sets the attribute ll5.
     *
     * @param ll5 list of ll5
     */
    void ll5(List<String> ll5);

    /**
     * Sets the attribute ll6.
     *
     * @param ll6 list of ll6
     */
    void ll6(List<Ll6Enum> ll6);

    /**
     * Sets the attribute ll7.
     *
     * @param ll7 list of ll7
     */
    void ll7(List<Bitdef> ll7);

    /**
     * Sets the attribute ll8.
     *
     * @param ll8 list of ll8
     */
    void ll8(List<byte[]> ll8);

    /**
     * Sets the attribute ll9.
     *
     * @param ll9 list of ll9
     */
    void ll9(List<Id> ll9);

    /**
     * Sets the attribute modKey.
     *
     * @param modKey list of modKey
     */
    void modKey(List<ModKey> modKey);

    /**
     * Sets the attribute type.
     *
     * @param type list of type
     */
    void type(List<Type> type);

    /**
     * Sets the attribute val.
     *
     * @param val value of val
     */
    void val(Val val);

    /**
     * Adds to the list of tri.
     *
     * @param addTo value of tri
     */
    void addToTri(Class<? extends YangAutoPrefixInt> addTo);

    /**
     * Adds to the list of ll1.
     *
     * @param addTo value of ll1
     */
    void addToLl1(Ll1Union addTo);

    /**
     * Adds to the list of ll2.
     *
     * @param addTo value of ll2
     */
    void addToLl2(Class<? extends YangAutoPrefixInt> addTo);

    /**
     * Adds to the list of ll3.
     *
     * @param addTo value of ll3
     */
    void addToLl3(Tdef1 addTo);

    /**
     * Adds to the list of ll4.
     *
     * @param addTo value of ll4
     */
    void addToLl4(Class<? extends YangAutoPrefixInt> addTo);

    /**
     * Adds to the list of ll5.
     *
     * @param addTo value of ll5
     */
    void addToLl5(String addTo);

    /**
     * Adds to the list of ll6.
     *
     * @param addTo value of ll6
     */
    void addToLl6(Ll6Enum addTo);

    /**
     * Adds to the list of ll7.
     *
     * @param addTo value of ll7
     */
    void addToLl7(Bitdef addTo);

    /**
     * Adds to the list of ll8.
     *
     * @param addTo value of ll8
     */
    void addToLl8(byte[] addTo);

    /**
     * Adds to the list of ll9.
     *
     * @param addTo value of ll9
     */
    void addToLl9(Id addTo);

    /**
     * Adds to the list of modKey.
     *
     * @param addTo value of modKey
     */
    void addToModKey(ModKey addTo);

    /**
     * Adds to the list of type.
     *
     * @param addTo value of type
     */
    void addToType(Type addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}