/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll;

import java.util.Objects;

/**
 * Represents the implementation of tpdfempty.
 */
public final class Tpdfempty {

    private boolean empty;

    /**
     * Creates an instance of tpdfempty.
     */
    private Tpdfempty() {
    }

    /**
     * Creates an instance of empty.
     *
     * @param empty value of empty
     */
    public Tpdfempty(boolean empty) {
        this.empty = empty;
    }

    /**
     * Returns the object of tpdfempty for type empty.
     *
     * @param value value of tpdfempty for type empty
     * @return tpdfempty for type empty
     */
    public static Tpdfempty of(boolean value) {
        return new Tpdfempty(value);
    }

    /**
     * Returns the attribute empty.
     *
     * @return empty value of empty
     */
    public boolean empty() {
        return empty;
    }
    /**
     * Sets the attribute empty.
     *
     * @param empty value of empty
     */
    public void empty(boolean empty) {
        this.empty = empty;
    }

    @Override
    public int hashCode() {
        return Objects.hash(empty);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tpdfempty) {
            Tpdfempty other = (Tpdfempty) obj;
            return
                Objects.deepEquals(empty, other.empty);
        }
        return false;
    }

    @Override
    public String toString() {
        return empty ? "true" : "false";
    }
    /**
     * Returns the object of tpdfempty fromString input String tpdfempty.
     *
     * @param valInString value of input String
     * @return tpdfempty
     */
    public static Tpdfempty fromString(String valInString) {
        try {
            boolean tmpVal = Boolean.parseBoolean(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
