/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.cont1;

import java.util.BitSet;
import java.util.regex.Pattern;

/**
 * Represents ENUM data of lfbits.
 */
public enum Lfbits {

    /**
     * Represents bit1.
     */
    BIT1(0, "bit1"),

    /**
     * Represents bit2.
     */
    BIT2(1, "bit2"),

    /**
     * Represents bit3.
     */
    BIT3(2, "bit3"),

    /**
     * Represents bit4.
     */
    BIT4(3, "bit4");

    private int lfbits;
    private String schemaName;

    /**
     * Creates an instance of lfbits.
     *
     * @param lfbits value of lfbits
     */
     Lfbits(int lfbits, String schemaName) {
        this.lfbits = lfbits;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of lfbits for.
     *
     * @param value value of lfbits for
     * @return lfbits for
     */
    public static Lfbits of(int value) {
        switch (value) {
            case 0:
                return Lfbits.BIT1;
            case 1:
                return Lfbits.BIT2;
            case 2:
                return Lfbits.BIT3;
            case 3:
                return Lfbits.BIT4;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of lfbits for.
     *
     * @param value value of lfbits for
     * @return lfbits for
     */
    public static Lfbits of(String value) {
        switch (value) {
            case "bit1":
                return Lfbits.BIT1;
            case "bit2":
                return Lfbits.BIT2;
            case "bit3":
                return Lfbits.BIT3;
            case "bit4":
                return Lfbits.BIT4;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute lfbits.
     *
     * @return lfbits value of lfbits
     */
    public int lfbits() {
        return lfbits;
    }

    /**
     * Returns the object of lfbits fromString input String lfbits.
     *
     * @param valInString value of input String
     * @return lfbits
     */
    public static BitSet fromString(String valInString) {
        BitSet tmpVal = new BitSet();
        String[] bitNames = valInString.trim().split(Pattern.quote(" "));
        for (String bitName : bitNames) {
            Lfbits lfbits = of(bitName);
            if (lfbits != null) {
                tmpVal.set(lfbits.lfbits());
            }
        }
        if (tmpVal.isEmpty()) {
            throw new IllegalArgumentException("not a valid input element");
        }
        return tmpVal;
    }
    public static String toString(BitSet bits) {
        StringBuilder sBuild = new StringBuilder("");
        if (bits.get(Lfbits.BIT1.lfbits())) {
            sBuild.append("bit1");
            sBuild.append(" ");
        }
        if (bits.get(Lfbits.BIT2.lfbits())) {
            sBuild.append("bit2");
            sBuild.append(" ");
        }
        if (bits.get(Lfbits.BIT3.lfbits())) {
            sBuild.append("bit3");
            sBuild.append(" ");
        }
        if (bits.get(Lfbits.BIT4.lfbits())) {
            sBuild.append("bit4");
            sBuild.append(" ");
        }
        return sBuild.toString();
    }
}
