/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypesll.rev20131112.simpledatatypesll.tpdfun1;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of tpdfun1Union.
 */
public final class Tpdfun1Union {
    private short uint8;
    private BigDecimal decimal64;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of tpdfun1Union.
     */
    private Tpdfun1Union() {
    }

    /**
     * Creates an instance of uint8.
     *
     * @param uint8 value of uint8
     */
    public Tpdfun1Union(short uint8) {
        setValue.set(0);
        this.uint8 = uint8;
    }

    /**
     * Creates an instance of decimal64.
     *
     * @param decimal64 value of decimal64
     */
    public Tpdfun1Union(BigDecimal decimal64) {
        setValue.set(1);
        this.decimal64 = decimal64;
    }

    /**
     * Returns the object of tpdfun1Union for type uint8.
     *
     * @param value value of tpdfun1Union for type uint8
     * @return tpdfun1Union for type uint8
     */
    public static Tpdfun1Union of(short value) {
        return new Tpdfun1Union(value);
    }

    /**
     * Returns the object of tpdfun1Union for type decimal64.
     *
     * @param value value of tpdfun1Union for type decimal64
     * @return tpdfun1Union for type decimal64
     */
    public static Tpdfun1Union of(BigDecimal value) {
        return new Tpdfun1Union(value);
    }

    /**
     * Returns the attribute uint8.
     *
     * @return uint8 value of uint8
     */
    public short uint8() {
        return uint8;
    }
    /**
     * Returns the attribute decimal64.
     *
     * @return decimal64 value of decimal64
     */
    public BigDecimal decimal64() {
        return decimal64;
    }
    /**
     * Sets the attribute uint8.
     *
     * @param uint8 value of uint8
     */
    public void uint8(short uint8) {
        this.uint8 = uint8;
    }
    /**
     * Sets the attribute decimal64.
     *
     * @param decimal64 value of decimal64
     */
    public void decimal64(BigDecimal decimal64) {
        this.decimal64 = decimal64;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint8, decimal64);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tpdfun1Union) {
            Tpdfun1Union other = (Tpdfun1Union) obj;
            return
                Objects.deepEquals(uint8, other.uint8) &&
                Objects.deepEquals(decimal64, other.decimal64);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint8);
        }
        if (setValue.get(1)) {
            return decimal64.toString();
        }
        return null;
    }
    /**
     * Returns the object of tpdfun1Union fromString input String tpdfun1Union.
     *
     * @param valInString value of input String
     * @return tpdfun1Union
     */
    public static Tpdfun1Union fromString(String valInString) {
        try {
            short tmpVal = Short.parseShort(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            BigDecimal tmpVal = new BigDecimal(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
