/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications.filters.Filter;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of filters.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultFilters extends InnerModelObject implements Filters {
    protected List<Filter> filter;

    @Override
    public List<Filter> filter() {
        return filter;
    }

    @Override
    public void filter(List<Filter> filter) {
        this.filter = filter;
    }

    @Override
    public void addToFilter(Filter addTo) {
        if (filter == null) {
            filter = new ArrayList<>();
        }
        filter.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(filter);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFilters) {
            DefaultFilters other = (DefaultFilters) obj;
            return
                Objects.deepEquals(filter, other.filter);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("filter=" + filter)
            .toString();
    }


    /**
     * Creates an instance of defaultFilters.
     */
    public DefaultFilters() {
    }

}