/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfeventnotifications.rev20161027.yrtietfeventnotifications;

/**
 * Represents the implementation of errorOther.
 */
public abstract class ErrorOther extends Error {

    /**
     * Returns the attribute error-other.
     *
     * @return error-other value of error-other
     */
    public static String errorOtherToString() {
        return "error-other";
    }

    /**
     * Returns the object of errorOther fromString input String errorOther.
     *
     * @param valInString value of input String
     * @return errorOther
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("error-other")) {
            return ErrorOther.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}